/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hop.core.BlockingRowSet;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.junit.Assert;

public class PipelineTestingUtil {
    public static List<Object[]> execute(BaseTransform transform, int expectedRowsAmount, boolean checkIsDone) throws Exception {
        int i;
        BlockingRowSet output = new BlockingRowSet(Math.max(1, expectedRowsAmount));
        transform.setOutputRowSets(Collections.singletonList(output));
        ArrayList<Object[]> result = new ArrayList<Object[]>(expectedRowsAmount);
        for (i = 0; transform.processRow() && i < expectedRowsAmount; ++i) {
            Object[] row = output.getRowImmediate();
            Assert.assertNotNull((String)Integer.toString(i), (Object)row);
            result.add(row);
        }
        Assert.assertEquals((String)"The amount of executions should be equal to expected", (long)expectedRowsAmount, (long)i);
        if (checkIsDone) {
            Assert.assertTrue((boolean)output.isDone());
        }
        return result;
    }

    public static void assertResult(Object[] expectedRow, Object[] actualRow) {
        PipelineTestingUtil.assertRow(0, expectedRow, actualRow);
    }

    public static void assertResult(List<Object[]> expected, List<Object[]> actual) {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            Object[] expectedRow = expected.get(i);
            Object[] actualRow = actual.get(i);
            PipelineTestingUtil.assertRow(i, expectedRow, actualRow);
        }
    }

    private static void assertRow(int index, Object[] expected, Object[] actual) {
        int i;
        boolean sizeCondition;
        Assert.assertNotNull((Object)actual);
        boolean bl = sizeCondition = expected.length <= actual.length;
        if (!sizeCondition) {
            Assert.fail((String)String.format("Row [%d]: expected.length=[%d]; actual.length=[%d]", index, expected.length, actual.length));
        }
        for (i = 0; i < expected.length; ++i) {
            Assert.assertEquals((String)String.format("[%d][%d]", index, i), (Object)expected[i], (Object)actual[i]);
        }
        while (i < actual.length) {
            Assert.assertNull((Object)actual[i]);
            ++i;
        }
    }
}

