/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline;

import java.util.concurrent.TimeUnit;
import org.apache.hop.core.IRowSet;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.pipeline.RowProducer;
import org.apache.hop.pipeline.transform.ITransform;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class RowProducerTest {
    RowProducer rowProducer;
    ITransform iTransform;
    IRowSet rowSet;
    IRowMeta rowMeta;
    Object[] rowData;

    @Before
    public void setUp() throws Exception {
        this.iTransform = (ITransform)Mockito.mock(ITransform.class);
        this.rowSet = (IRowSet)Mockito.mock(IRowSet.class);
        this.rowProducer = new RowProducer(this.iTransform, this.rowSet);
        this.rowMeta = (IRowMeta)Mockito.mock(IRowMeta.class);
        this.rowData = new Object[0];
    }

    @Test
    public void testPutRow2Arg() throws Exception {
        Mockito.when((Object)this.rowSet.putRowWait((IRowMeta)Matchers.any(IRowMeta.class), (Object[])Matchers.any(Object[].class), Matchers.anyLong(), (TimeUnit)((Object)Matchers.any(TimeUnit.class)))).thenReturn((Object)true);
        this.rowProducer.putRow(this.rowMeta, this.rowData);
        ((IRowSet)Mockito.verify((Object)this.rowSet, (VerificationMode)Mockito.times((int)1))).putRowWait(this.rowMeta, this.rowData, Long.MAX_VALUE, TimeUnit.DAYS);
        Assert.assertTrue((boolean)this.rowProducer.putRow(this.rowMeta, this.rowData, true));
    }

    @Test
    public void testPutRow3Arg() throws Exception {
        Mockito.when((Object)this.rowSet.putRowWait((IRowMeta)Matchers.any(IRowMeta.class), (Object[])Matchers.any(Object[].class), Matchers.anyLong(), (TimeUnit)((Object)Matchers.any(TimeUnit.class)))).thenReturn((Object)true);
        this.rowProducer.putRow(this.rowMeta, this.rowData, false);
        ((IRowSet)Mockito.verify((Object)this.rowSet, (VerificationMode)Mockito.times((int)1))).putRow(this.rowMeta, this.rowData);
    }

    @Test
    public void testPutRowWait() throws Exception {
        this.rowProducer.putRowWait(this.rowMeta, this.rowData, 1L, TimeUnit.MILLISECONDS);
        ((IRowSet)Mockito.verify((Object)this.rowSet, (VerificationMode)Mockito.times((int)1))).putRowWait(this.rowMeta, this.rowData, 1L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void testFinished() throws Exception {
        this.rowProducer.finished();
        ((IRowSet)Mockito.verify((Object)this.rowSet, (VerificationMode)Mockito.times((int)1))).setDone();
    }

    @Test
    public void testGetSetRowSet() throws Exception {
        Assert.assertEquals((Object)this.rowSet, (Object)this.rowProducer.getRowSet());
        this.rowProducer.setRowSet(null);
        Assert.assertNull((Object)this.rowProducer.getRowSet());
        IRowSet newRowSet = (IRowSet)Mockito.mock(IRowSet.class);
        this.rowProducer.setRowSet(newRowSet);
        Assert.assertEquals((Object)newRowSet, (Object)this.rowProducer.getRowSet());
    }

    @Test
    public void testGetSetTransform() throws Exception {
        Assert.assertEquals((Object)this.iTransform, (Object)this.rowProducer.getTransform());
        this.rowProducer.setTransform(null);
        Assert.assertNull((Object)this.rowProducer.getTransform());
        ITransform newTransform = (ITransform)Mockito.mock(ITransform.class);
        this.rowProducer.setTransform(newTransform);
        Assert.assertEquals((Object)newTransform, (Object)this.rowProducer.getTransform());
    }
}

