/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline;

import org.apache.hop.core.Const;
import org.apache.hop.core.HopEnvironment;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LoggingObject;
import org.apache.hop.core.parameters.INamedParameters;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.TransformWithMappingMeta;
import org.apache.hop.pipeline.engines.local.LocalPipelineEngine;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TransformWithMappingMetaTest {
    @Mock
    PipelineMeta pipelineMeta;

    @Before
    public void setupBefore() throws Exception {
        HopEnvironment.init();
    }

    @Test
    public void activateParamsTest() throws Exception {
        String childParam = "childParam";
        String childValue = "childValue";
        String paramOverwrite = "paramOverwrite";
        String parentValue = "parentValue";
        String transformValue = "transformValue";
        Variables parent = new Variables();
        parent.setVariable(paramOverwrite, parentValue);
        PipelineMeta childVariableSpace = new PipelineMeta();
        childVariableSpace.addParameterDefinition(childParam, "", "");
        LocalPipelineEngine pipeline = new LocalPipelineEngine(this.pipelineMeta, (IVariables)parent, (ILoggingObject)new LoggingObject((Object)"Test"));
        pipeline.setParameterValue(childParam, childValue);
        String[] parameters = pipeline.listParameters();
        TransformWithMappingMeta.activateParams((IVariables)pipeline, (INamedParameters)pipeline, (IVariables)parent, (String[])parameters, (String[])new String[]{childParam, paramOverwrite}, (String[])new String[]{childValue, transformValue}, (boolean)true);
        Assert.assertEquals((Object)childValue, (Object)pipeline.getVariable(childParam));
        Assert.assertEquals((Object)transformValue, (Object)pipeline.getVariable(paramOverwrite));
    }

    @Test
    public void activateParamsWithTruePassParametersFlagTest() throws Exception {
        String childParam = "childParam";
        String childValue = "childValue";
        String paramOverwrite = "paramOverwrite";
        String parentValue = "parentValue";
        String transformValue = "transformValue";
        String parentAndChildParameter = "parentAndChildParameter";
        Variables parent = new Variables();
        parent.setVariable(paramOverwrite, parentValue);
        parent.setVariable(parentAndChildParameter, parentValue);
        PipelineMeta childVariableSpace = new PipelineMeta();
        childVariableSpace.addParameterDefinition(childParam, "", "");
        childVariableSpace.addParameterDefinition(parentAndChildParameter, "", "");
        LocalPipelineEngine pipeline = new LocalPipelineEngine(this.pipelineMeta, (IVariables)parent, (ILoggingObject)new LoggingObject((Object)"Test"));
        pipeline.setParameterValue(childParam, childValue);
        pipeline.setParameterValue(parentAndChildParameter, childValue);
        String[] parameters = pipeline.listParameters();
        TransformWithMappingMeta.activateParams((IVariables)pipeline, (INamedParameters)pipeline, (IVariables)parent, (String[])parameters, (String[])new String[]{childParam, paramOverwrite}, (String[])new String[]{childValue, transformValue}, (boolean)true);
        Assert.assertEquals((Object)childValue, (Object)pipeline.getVariable(childParam));
        Assert.assertEquals((Object)transformValue, (Object)pipeline.getVariable(paramOverwrite));
        Assert.assertEquals((Object)parentValue, (Object)pipeline.getVariable(parentAndChildParameter));
    }

    @Test
    public void replaceVariablesWithWorkflowInternalVariablesTest() {
        String variableOverwrite = "paramOverwrite";
        String variableChildOnly = "childValueVariable";
        Variables ChildVariables = new Variables();
        Variables replaceByParentVariables = new Variables();
        for (String internalVariable : Const.INTERNAL_WORKFLOW_VARIABLES) {
            ChildVariables.setVariable(internalVariable, "childValue");
            replaceByParentVariables.setVariable(internalVariable, "parentValue");
        }
        ChildVariables.setVariable(variableChildOnly, "childValueVariable");
        ChildVariables.setVariable(variableOverwrite, "childNotInternalValue");
        replaceByParentVariables.setVariable(variableOverwrite, "parentNotInternalValue");
        TransformWithMappingMeta.replaceVariableValues((IVariables)ChildVariables, (IVariables)replaceByParentVariables);
        Assert.assertEquals((Object)"childValue", (Object)ChildVariables.getVariable("Internal.Entry.Current.Folder"));
        Assert.assertEquals((Object)"parentNotInternalValue", (Object)ChildVariables.getVariable(variableOverwrite));
        Assert.assertEquals((Object)variableChildOnly, (Object)ChildVariables.getVariable(variableChildOnly));
    }

    @Test
    public void replaceVariablesWithPipelineInternalVariablesTest() {
        String variableOverwrite = "paramOverwrite";
        String variableChildOnly = "childValueVariable";
        Variables ChildVariables = new Variables();
        Variables replaceByParentVariables = new Variables();
        for (String internalVariable : Const.INTERNAL_PIPELINE_VARIABLES) {
            ChildVariables.setVariable(internalVariable, "childValue");
            replaceByParentVariables.setVariable(internalVariable, "parentValue");
        }
        ChildVariables.setVariable(variableChildOnly, "childValueVariable");
        ChildVariables.setVariable(variableOverwrite, "childNotInternalValue");
        replaceByParentVariables.setVariable(variableOverwrite, "parentNotInternalValue");
        TransformWithMappingMeta.replaceVariableValues((IVariables)ChildVariables, (IVariables)replaceByParentVariables);
        Assert.assertEquals((Object)"childValue", (Object)ChildVariables.getVariable("Internal.Entry.Current.Folder"));
        Assert.assertEquals((Object)"parentNotInternalValue", (Object)ChildVariables.getVariable(variableOverwrite));
        Assert.assertEquals((Object)variableChildOnly, (Object)ChildVariables.getVariable(variableChildOnly));
    }
}

