/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transform;

import java.util.List;
import org.apache.hop.core.database.Database;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformIOMeta;
import org.apache.hop.pipeline.transform.TransformIOMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.stream.IStream;
import org.apache.hop.pipeline.transform.stream.Stream;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class BaseTransformMetaCloningTest {
    @Test
    public void testClone() throws Exception {
        Database db1 = (Database)Mockito.mock(Database.class);
        Database db2 = (Database)Mockito.mock(Database.class);
        TransformMeta transformMeta = (TransformMeta)Mockito.mock(TransformMeta.class);
        BaseTransformMeta meta = new BaseTransformMeta();
        meta.setChanged(true);
        meta.databases = new Database[]{db1, db2};
        TransformIOMeta ioMeta = new TransformIOMeta(true, false, false, false, false, false);
        meta.setTransformIOMeta((ITransformIOMeta)ioMeta);
        meta.parentTransformMeta = transformMeta;
        BaseTransformMeta clone = (BaseTransformMeta)meta.clone();
        Assert.assertTrue((boolean)clone.hasChanged());
        Assert.assertTrue((clone.databases == meta.databases ? 1 : 0) != 0);
        Assert.assertArrayEquals((Object[])meta.databases, (Object[])clone.databases);
        Assert.assertEquals((Object)meta.parentTransformMeta, (Object)clone.parentTransformMeta);
        ITransformIOMeta cloneIOMeta = clone.getTransformIOMeta();
        Assert.assertNotNull((Object)cloneIOMeta);
        Assert.assertEquals((Object)ioMeta.isInputAcceptor(), (Object)cloneIOMeta.isInputAcceptor());
        Assert.assertEquals((Object)ioMeta.isInputDynamic(), (Object)cloneIOMeta.isInputDynamic());
        Assert.assertEquals((Object)ioMeta.isInputOptional(), (Object)cloneIOMeta.isInputOptional());
        Assert.assertEquals((Object)ioMeta.isOutputDynamic(), (Object)cloneIOMeta.isOutputDynamic());
        Assert.assertEquals((Object)ioMeta.isOutputProducer(), (Object)cloneIOMeta.isOutputProducer());
        Assert.assertEquals((Object)ioMeta.isSortedDataRequired(), (Object)cloneIOMeta.isSortedDataRequired());
        Assert.assertNotNull((Object)cloneIOMeta.getInfoStreams());
        Assert.assertEquals((long)0L, (long)cloneIOMeta.getInfoStreams().size());
    }

    @Test
    public void testCloneWithInfoTransforms() throws Exception {
        Database db1 = (Database)Mockito.mock(Database.class);
        Database db2 = (Database)Mockito.mock(Database.class);
        TransformMeta transformMeta = (TransformMeta)Mockito.mock(TransformMeta.class);
        BaseTransformMeta meta = new BaseTransformMeta();
        meta.setChanged(true);
        meta.databases = new Database[]{db1, db2};
        TransformIOMeta ioMeta = new TransformIOMeta(true, false, false, false, false, false);
        meta.setTransformIOMeta((ITransformIOMeta)ioMeta);
        String refTransformName = "referenced transform";
        TransformMeta refTransformMeta = (TransformMeta)Mockito.mock(TransformMeta.class);
        ((TransformMeta)Mockito.doReturn((Object)"referenced transform").when((Object)refTransformMeta)).getName();
        Stream stream = new Stream(IStream.StreamType.INFO, refTransformMeta, null, null, "referenced transform");
        ioMeta.addStream((IStream)stream);
        meta.parentTransformMeta = transformMeta;
        BaseTransformMeta clone = (BaseTransformMeta)meta.clone();
        Assert.assertTrue((boolean)clone.hasChanged());
        Assert.assertTrue((clone.databases == meta.databases ? 1 : 0) != 0);
        Assert.assertArrayEquals((Object[])meta.databases, (Object[])clone.databases);
        Assert.assertEquals((Object)meta.parentTransformMeta, (Object)clone.parentTransformMeta);
        ITransformIOMeta cloneIOMeta = clone.getTransformIOMeta();
        Assert.assertNotNull((Object)cloneIOMeta);
        Assert.assertEquals((Object)ioMeta.isInputAcceptor(), (Object)cloneIOMeta.isInputAcceptor());
        Assert.assertEquals((Object)ioMeta.isInputDynamic(), (Object)cloneIOMeta.isInputDynamic());
        Assert.assertEquals((Object)ioMeta.isInputOptional(), (Object)cloneIOMeta.isInputOptional());
        Assert.assertEquals((Object)ioMeta.isOutputDynamic(), (Object)cloneIOMeta.isOutputDynamic());
        Assert.assertEquals((Object)ioMeta.isOutputProducer(), (Object)cloneIOMeta.isOutputProducer());
        Assert.assertEquals((Object)ioMeta.isSortedDataRequired(), (Object)cloneIOMeta.isSortedDataRequired());
        List clonedInfoStreams = cloneIOMeta.getInfoStreams();
        Assert.assertNotNull((Object)clonedInfoStreams);
        Assert.assertEquals((long)1L, (long)clonedInfoStreams.size());
        IStream clonedStream = (IStream)clonedInfoStreams.get(0);
        Assert.assertNotSame((Object)stream, (Object)clonedStream);
        Assert.assertEquals((Object)stream.getStreamType(), (Object)clonedStream.getStreamType());
        Assert.assertEquals((Object)"referenced transform", (Object)clonedStream.getTransformName());
        Assert.assertSame((Object)refTransformMeta, (Object)clonedStream.getTransformMeta());
    }
}

