/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transform;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.BlockingRowSet;
import org.apache.hop.core.IProgressMonitor;
import org.apache.hop.core.IRowSet;
import org.apache.hop.core.QueueRowSet;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.SingleRowRowSet;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.fileinput.NonAccessibleFileObject;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engines.local.LocalPipelineEngine;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.IRowHandler;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformFinishedListener;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.mock.TransformMockHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class BaseTransformTest {
    private TransformMockHelper<ITransformMeta, ITransformData> mockHelper;
    @Mock
    IRowHandler rowHandler;

    @Before
    public void setup() throws Exception {
        this.mockHelper = new TransformMockHelper<ITransformMeta, ITransformData>("BASE TRANSFORM", ITransformMeta.class, ITransformData.class);
        Mockito.when((Object)this.mockHelper.logChannelFactory.create(Matchers.any(), (ILoggingObject)Matchers.any(ILoggingObject.class))).thenReturn((Object)this.mockHelper.iLogChannel);
    }

    @After
    public void tearDown() {
        this.mockHelper.cleanUp();
    }

    @Test
    public void testBaseTransformGetLogLevelWontThrowNPEWithNullLog() {
        Mockito.when((Object)this.mockHelper.logChannelFactory.create(Matchers.any(), (ILoggingObject)Matchers.any(ILoggingObject.class))).thenAnswer(invocation -> {
            ((BaseTransform)invocation.getArguments()[0]).getLogLevel();
            return this.mockHelper.iLogChannel;
        });
        new BaseTransform(this.mockHelper.transformMeta, this.mockHelper.iTransformMeta, this.mockHelper.iTransformData, 0, this.mockHelper.pipelineMeta, this.mockHelper.pipeline).getLogLevel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTransformListenersConcurrentModification() throws InterruptedException {
        final BaseTransform baseTransform = new BaseTransform(this.mockHelper.transformMeta, this.mockHelper.iTransformMeta, this.mockHelper.iTransformData, 0, this.mockHelper.pipelineMeta, this.mockHelper.pipeline);
        final AtomicBoolean done = new AtomicBoolean(false);
        Thread addListeners = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!done.get()) {
                    baseTransform.addTransformFinishedListener((ITransformFinishedListener)Mockito.mock(ITransformFinishedListener.class));
                    AtomicBoolean atomicBoolean = done;
                    synchronized (atomicBoolean) {
                        done.notify();
                    }
                }
            }
        };
        try {
            addListeners.start();
            AtomicBoolean atomicBoolean = done;
            synchronized (atomicBoolean) {
                while (baseTransform.getTransformFinishedListeners().size() < 20) {
                    done.wait();
                }
            }
            baseTransform.markStart();
            atomicBoolean = done;
            synchronized (atomicBoolean) {
                while (baseTransform.getTransformFinishedListeners().size() < 100) {
                    done.wait();
                }
            }
            baseTransform.markStop();
        }
        finally {
            done.set(true);
            addListeners.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void resultFilesMapIsSafeForConcurrentModification() throws Exception {
        BaseTransform transform = new BaseTransform(this.mockHelper.transformMeta, this.mockHelper.iTransformMeta, this.mockHelper.iTransformData, 0, this.mockHelper.pipelineMeta, this.mockHelper.pipeline);
        AtomicBoolean complete = new AtomicBoolean(false);
        int FILES_AMOUNT = 10000;
        Thread filesProducer = new Thread(() -> {
            try {
                for (int i = 0; i < 10000; ++i) {
                    transform.addResultFile(new ResultFile(0, (FileObject)new NonAccessibleFileObject(Integer.toString(i)), null, null));
                    try {
                        Thread.sleep(1L);
                        continue;
                    }
                    catch (Exception e) {
                        Assert.fail((String)e.getMessage());
                    }
                }
            }
            finally {
                complete.set(true);
            }
        });
        filesProducer.start();
        try {
            while (!complete.get()) {
                for (Map.Entry entry : transform.getResultFiles().entrySet()) {
                    entry.getKey();
                }
            }
        }
        finally {
            filesProducer.join();
        }
    }

    @Test
    public void outputRowMetasAreNotSharedAmongSeveralStreams() throws Exception {
        SingleRowRowSet rs1 = new SingleRowRowSet();
        SingleRowRowSet rs2 = new SingleRowRowSet();
        Mockito.when((Object)this.mockHelper.pipeline.isRunning()).thenReturn((Object)true);
        BaseTransform baseTransform = new BaseTransform(this.mockHelper.transformMeta, this.mockHelper.iTransformMeta, this.mockHelper.iTransformData, 0, this.mockHelper.pipelineMeta, this.mockHelper.pipeline);
        baseTransform.setStopped(false);
        baseTransform.setRepartitioning(0);
        baseTransform.setOutputRowSets(Arrays.asList(rs1, rs2));
        for (IRowSet rowSet : baseTransform.getOutputRowSets()) {
            Assert.assertNull((String)"RowMeta should be null, since no calls were done", (Object)rowSet.getRowMeta());
        }
        RowMeta rowMeta = new RowMeta();
        rowMeta.addValueMeta((IValueMeta)new ValueMetaString("string"));
        rowMeta.addValueMeta((IValueMeta)new ValueMetaInteger("integer"));
        baseTransform.putRow((IRowMeta)rowMeta, new Object[]{"a", 1});
        IRowMeta meta1 = rs1.getRowMeta();
        IRowMeta meta2 = rs2.getRowMeta();
        Assert.assertNotNull((Object)meta1);
        Assert.assertNotNull((Object)meta2);
        for (IValueMeta meta : meta1.getValueMetaList()) {
            Assert.assertTrue((String)meta.getName(), (boolean)meta2.exists(meta));
        }
        Assert.assertFalse((meta1 == meta2 ? 1 : 0) != 0);
    }

    @Test
    public void getRowWithRowHandler() throws HopException {
        BaseTransform baseTransform = new BaseTransform(this.mockHelper.transformMeta, this.mockHelper.iTransformMeta, this.mockHelper.iTransformData, 0, this.mockHelper.pipelineMeta, this.mockHelper.pipeline);
        baseTransform.setRowHandler(this.rowHandler);
        baseTransform.getRow();
        ((IRowHandler)Mockito.verify((Object)this.rowHandler, (VerificationMode)Mockito.times((int)1))).getRow();
    }

    @Test
    public void putRowWithRowHandler() throws HopException {
        BaseTransform baseTransform = new BaseTransform(this.mockHelper.transformMeta, this.mockHelper.iTransformMeta, this.mockHelper.iTransformData, 0, this.mockHelper.pipelineMeta, this.mockHelper.pipeline);
        baseTransform.setRowHandler(this.rowHandler);
        IRowMeta iRowMeta = (IRowMeta)Mockito.mock(IRowMeta.class);
        Object[] objects = new Object[]{"foo", "bar"};
        baseTransform.putRow(iRowMeta, objects);
        ((IRowHandler)Mockito.verify((Object)this.rowHandler, (VerificationMode)Mockito.times((int)1))).putRow(iRowMeta, objects);
    }

    @Test
    public void putErrorWithRowHandler() throws HopException {
        BaseTransform baseTransform = new BaseTransform(this.mockHelper.transformMeta, this.mockHelper.iTransformMeta, this.mockHelper.iTransformData, 0, this.mockHelper.pipelineMeta, this.mockHelper.pipeline);
        baseTransform.setRowHandler(this.rowHandler);
        IRowMeta iRowMeta = (IRowMeta)Mockito.mock(IRowMeta.class);
        Object[] objects = new Object[]{"foo", "bar"};
        baseTransform.putError(iRowMeta, objects, 3L, "desc", "field1,field2", "errorCode");
        ((IRowHandler)Mockito.verify((Object)this.rowHandler, (VerificationMode)Mockito.times((int)1))).putError(iRowMeta, objects, 3L, "desc", "field1,field2", "errorCode");
    }

    @Test
    public void putGetFromPutToDefaultRowHandlerMethods() throws HopException {
        BaseTransform baseTransform = new BaseTransform(this.mockHelper.transformMeta, this.mockHelper.iTransformMeta, this.mockHelper.iTransformData, 0, this.mockHelper.pipelineMeta, this.mockHelper.pipeline);
        baseTransform.setRowHandler(this.rowHandlerWithDefaultMethods());
        IRowMeta iRowMeta = (IRowMeta)Mockito.mock(IRowMeta.class);
        Object[] objects = new Object[]{"foo", "bar"};
        try {
            baseTransform.putRowTo(iRowMeta, objects, (IRowSet)new QueueRowSet());
            Assert.fail((String)"Expected default exception for putRowTo");
        }
        catch (UnsupportedOperationException uoe) {
            Assert.assertTrue((boolean)uoe.getMessage().contains(this.getClass().getName()));
        }
        try {
            baseTransform.getRowFrom((IRowSet)new QueueRowSet());
            Assert.fail((String)"Expected default exception for getRowFrom");
        }
        catch (UnsupportedOperationException uoe) {
            Assert.assertTrue((boolean)uoe.getMessage().contains(this.getClass().getName()));
        }
    }

    private IRowHandler rowHandlerWithDefaultMethods() {
        return new IRowHandler(){

            public Object[] getRow() throws HopException {
                return new Object[0];
            }

            public void putRow(IRowMeta rowMeta, Object[] row) throws HopTransformException {
            }

            public void putError(IRowMeta rowMeta, Object[] row, long nrErrors, String errorDescriptions, String fieldNames, String errorCodes) throws HopTransformException {
            }
        };
    }

    @Test
    public void notEmptyFieldName() throws HopTransformException {
        BaseTransform baseTransform = new BaseTransform(this.mockHelper.transformMeta, this.mockHelper.iTransformMeta, this.mockHelper.iTransformData, 0, this.mockHelper.pipelineMeta, this.mockHelper.pipeline);
        baseTransform.setRowHandler(this.rowHandler);
        RowMeta rowMeta = new RowMeta();
        rowMeta.addValueMeta((IValueMeta)new ValueMetaBase("name", 5));
        baseTransform.putRow((IRowMeta)rowMeta, new Object[]{0});
    }

    @Test(expected=HopTransformException.class)
    public void nullFieldName() throws HopTransformException {
        BaseTransform baseTransform = new BaseTransform(this.mockHelper.transformMeta, this.mockHelper.iTransformMeta, this.mockHelper.iTransformData, 0, this.mockHelper.pipelineMeta, this.mockHelper.pipeline);
        baseTransform.setRowHandler(this.rowHandler);
        baseTransform.setAllowEmptyFieldNamesAndTypes(false);
        RowMeta rowMeta = new RowMeta();
        rowMeta.addValueMeta((IValueMeta)new ValueMetaBase(null, 5));
        baseTransform.putRow((IRowMeta)rowMeta, new Object[]{0});
    }

    @Test(expected=HopTransformException.class)
    public void emptyFieldName() throws HopTransformException {
        BaseTransform baseTransform = new BaseTransform(this.mockHelper.transformMeta, this.mockHelper.iTransformMeta, this.mockHelper.iTransformData, 0, this.mockHelper.pipelineMeta, this.mockHelper.pipeline);
        baseTransform.setRowHandler(this.rowHandler);
        baseTransform.setAllowEmptyFieldNamesAndTypes(false);
        RowMeta rowMeta = new RowMeta();
        rowMeta.addValueMeta((IValueMeta)new ValueMetaBase("", 5));
        baseTransform.putRow((IRowMeta)rowMeta, new Object[]{0});
    }

    @Test(expected=HopTransformException.class)
    public void blankFieldName() throws HopTransformException {
        BaseTransform baseTransform = new BaseTransform(this.mockHelper.transformMeta, this.mockHelper.iTransformMeta, this.mockHelper.iTransformData, 0, this.mockHelper.pipelineMeta, this.mockHelper.pipeline);
        baseTransform.setRowHandler(this.rowHandler);
        baseTransform.setAllowEmptyFieldNamesAndTypes(false);
        RowMeta rowMeta = new RowMeta();
        rowMeta.addValueMeta((IValueMeta)new ValueMetaBase("  ", 5));
        baseTransform.putRow((IRowMeta)rowMeta, new Object[]{0});
    }

    @Test
    public void testGetRowSafeModeEnabled() throws HopException {
        Pipeline pipelineMock = (Pipeline)Mockito.spy((Object)new LocalPipelineEngine());
        Mockito.when((Object)pipelineMock.isSafeModeEnabled()).thenReturn((Object)true);
        BaseTransform baseTransformSpy = (BaseTransform)Mockito.spy((Object)new BaseTransform(this.mockHelper.transformMeta, this.mockHelper.iTransformMeta, this.mockHelper.iTransformData, 0, this.mockHelper.pipelineMeta, pipelineMock));
        ((BaseTransform)Mockito.doNothing().when((Object)baseTransformSpy)).waitUntilPipelineIsStarted();
        BlockingRowSet rowSet = new BlockingRowSet(1);
        List<IValueMeta> valueMetaList = Arrays.asList(new ValueMetaInteger("x"), new ValueMetaString("a"));
        RowMeta rowMeta = new RowMeta();
        rowMeta.setValueMetaList(valueMetaList);
        Object[] row = new Object[]{};
        rowSet.putRow((IRowMeta)rowMeta, row);
        baseTransformSpy.setInputRowSets(Arrays.asList(rowSet));
        ((BaseTransform)Mockito.doReturn((Object)rowSet).when((Object)baseTransformSpy)).currentInputStream();
        baseTransformSpy.getRow();
        ((PipelineMeta)Mockito.verify((Object)this.mockHelper.pipelineMeta, (VerificationMode)Mockito.times((int)1))).checkRowMixingStatically((IVariables)Matchers.any(IVariables.class), (TransformMeta)Matchers.any(TransformMeta.class), (IProgressMonitor)Mockito.anyObject());
    }
}

