/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import org.apache.hop.core.BlockingRowSet;
import org.apache.hop.core.IRowSet;
import org.apache.hop.pipeline.transform.DynamicWaitTimes;

public class DynamicWaitTimesTest
extends TestCase {
    DynamicWaitTimes.SingleStreamStatus status;
    AtomicInteger activeStreamIndex = new AtomicInteger();

    public void testSingleStreamStatus() {
        BlockingRowSet rowSet = new BlockingRowSet(3);
        this.status = DynamicWaitTimes.build(Collections.singletonList(rowSet), () -> 0, (Integer)20);
        DynamicWaitTimesTest.assertEquals((long)1L, (long)this.status.get());
        this.status.adjust(true, (IRowSet)rowSet);
        DynamicWaitTimesTest.assertEquals((long)2L, (long)this.status.get());
        for (int i = 0; i < 10; ++i) {
            this.status.adjust(true, (IRowSet)rowSet);
        }
        DynamicWaitTimesTest.assertEquals((long)20L, (long)this.status.get());
    }

    public void testMultiStreamStatus() {
        ArrayList<BlockingRowSet> rowSetList = new ArrayList<BlockingRowSet>(Arrays.asList(new BlockingRowSet(1), new BlockingRowSet(2), new BlockingRowSet(7)));
        this.status = DynamicWaitTimes.build(rowSetList, () -> this.activeStreamIndex.get(), (Integer)20);
        for (IRowSet iRowSet : rowSetList) {
            this.status.adjust(false, iRowSet);
            DynamicWaitTimesTest.assertEquals((long)1L, (long)this.status.get());
            DynamicWaitTimesTest.assertFalse((boolean)this.status.allowAdjust());
            this.activeStreamIndex.incrementAndGet();
        }
        this.activeStreamIndex.set(0);
        this.testAPeriod(rowSetList, 10);
        DynamicWaitTimesTest.assertTrue((boolean)this.status.allowAdjust());
        this.activeStreamIndex.set(0);
        this.status.doReset(0);
        this.testAPeriod(rowSetList, 4);
        DynamicWaitTimesTest.assertTrue((boolean)this.status.allowAdjust());
        this.activeStreamIndex.set(0);
        this.status.adjust(true, (IRowSet)rowSetList.get(0));
        this.status.adjust(true, (IRowSet)rowSetList.get(1));
        this.status.remove((IRowSet)rowSetList.get(1));
        rowSetList.remove(1);
        this.testAPeriod(rowSetList, 10);
        DynamicWaitTimesTest.assertTrue((boolean)this.status.allowAdjust());
        this.activeStreamIndex.set(0);
        this.status.remove((IRowSet)rowSetList.get(1));
        rowSetList.remove(1);
        this.testAPeriod(rowSetList, 10);
        DynamicWaitTimesTest.assertFalse((boolean)this.status.allowAdjust());
        this.testAPeriod(rowSetList, 10);
        DynamicWaitTimesTest.assertFalse((boolean)this.status.allowAdjust());
        this.activeStreamIndex.set(0);
        this.status.remove((IRowSet)rowSetList.get(0));
        rowSetList.remove(0);
        this.testAPeriod(rowSetList, 10);
    }

    private void testAPeriod(List<IRowSet> rowSetList, int times) {
        for (int j = 0; j < rowSetList.size() * times; ++j) {
            this.activeStreamIndex.set(0);
            for (IRowSet iRowSet : rowSetList) {
                this.status.adjust(true, iRowSet);
                this.activeStreamIndex.incrementAndGet();
            }
        }
    }
}

