/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transform;

import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.hop.core.util.AbstractTransformMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.partition.PartitionSchema;
import org.apache.hop.pipeline.transform.FakeRowDistribution;
import org.apache.hop.pipeline.transform.IRowDistribution;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.TransformPartitioningMeta;
import org.apache.hop.pipeline.transforms.missing.Missing;
import org.apache.hop.utils.TestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TransformMetaTest {
    private static final IVariables variables = new Variables();
    private static final Random rand = new Random();
    private static final String TRANSFORM_ID = "transform_id";

    @Test
    public void cloning() throws Exception {
        TransformMeta meta = TransformMetaTest.createTestMeta();
        TransformMeta clone = (TransformMeta)meta.clone();
        TransformMetaTest.assertEquals(meta, clone);
    }

    @Test
    public void testEqualsHashCodeConsistency() throws Exception {
        TransformMeta transform = new TransformMeta();
        transform.setName("transform");
        TestUtils.checkEqualsHashCodeConsistency(transform, transform);
        TransformMeta transformSame = new TransformMeta();
        transformSame.setName("transform");
        Assert.assertTrue((boolean)transform.equals((Object)transformSame));
        TestUtils.checkEqualsHashCodeConsistency(transform, transformSame);
        TransformMeta transformCaps = new TransformMeta();
        transformCaps.setName("TRANSFORM");
        TestUtils.checkEqualsHashCodeConsistency(transform, transformCaps);
        TransformMeta transformOther = new TransformMeta();
        transformOther.setName("something else");
        TestUtils.checkEqualsHashCodeConsistency(transform, transformOther);
    }

    @Test
    public void transformMetaXmlConsistency() throws Exception {
        TransformMeta meta = new TransformMeta("id", "name", null);
        Missing smi = new Missing(meta.getName(), meta.getTransformPluginId());
        meta.setTransform((ITransformMeta)smi);
        TransformMeta fromXml = TransformMeta.fromXml((String)meta.getXml());
        Assert.assertThat((Object)meta.getXml(), (Matcher)CoreMatchers.is((Object)fromXml.getXml()));
    }

    private static TransformMeta createTestMeta() throws Exception {
        ITransformMeta transformMetaInterface = (ITransformMeta)Mockito.mock(AbstractTransformMeta.class);
        Mockito.when((Object)transformMetaInterface.clone()).thenReturn((Object)transformMetaInterface);
        TransformMeta meta = new TransformMeta(TRANSFORM_ID, "transformName", transformMetaInterface);
        meta.setSelected(true);
        meta.setDistributes(false);
        meta.setCopiesString("2");
        meta.setLocation(1, 2);
        meta.setDescription("description");
        meta.setTerminator(true);
        boolean shouldDistribute = rand.nextBoolean();
        meta.setDistributes(shouldDistribute);
        if (shouldDistribute) {
            meta.setRowDistribution(TransformMetaTest.selectRowDistribution());
        }
        HashMap attributes = new HashMap();
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("1", "1");
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put("2", "2");
        attributes.put("qwerty", map1);
        attributes.put("asdfg", map2);
        meta.setAttributesMap(attributes);
        meta.setTransformPartitioningMeta(TransformMetaTest.createTransformPartitioningMeta("transformMethod", "transformSchema"));
        meta.setTargetTransformPartitioningMeta(TransformMetaTest.createTransformPartitioningMeta("targetMethod", "targetSchema"));
        return meta;
    }

    private static IRowDistribution selectRowDistribution() {
        return new FakeRowDistribution();
    }

    private static TransformPartitioningMeta createTransformPartitioningMeta(String method, String schemaName) throws Exception {
        TransformPartitioningMeta meta = new TransformPartitioningMeta(method, new PartitionSchema(schemaName, Collections.emptyList()));
        meta.setPartitionSchema(new PartitionSchema());
        return meta;
    }

    private static void assertEquals(TransformMeta meta, TransformMeta another) {
        Assert.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)meta, (Object)another, (boolean)false, TransformMeta.class, (String[])new String[]{"location", "targetTransformPartitioningMeta"}));
        boolean manualCheck = new EqualsBuilder().append(meta.getLocation().x, another.getLocation().x).append(meta.getLocation().y, another.getLocation().y).isEquals();
        Assert.assertTrue((boolean)manualCheck);
    }
}

