/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transform;

import java.util.ArrayList;
import org.apache.hop.core.HopEnvironment;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.TransformOption;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TransformOptionTest {
    @Mock
    TransformMeta transformMeta;
    @Mock
    IVariables variables;

    @BeforeClass
    public static void setUpBeforeClass() throws HopException {
        HopEnvironment.init();
    }

    @Before
    public void setup() {
        Mockito.when((Object)this.variables.resolve(Matchers.anyString())).thenAnswer(incovacationMock -> {
            Object[] arguments = incovacationMock.getArguments();
            return (String)arguments[0];
        });
    }

    @Test
    public void testCheckPass() {
        ArrayList remarks = new ArrayList();
        TransformOption.checkInteger(remarks, (TransformMeta)this.transformMeta, (IVariables)this.variables, (String)"IDENTIFIER", (String)"9");
        TransformOption.checkLong(remarks, (TransformMeta)this.transformMeta, (IVariables)this.variables, (String)"IDENTIFIER", (String)"9");
        TransformOption.checkBoolean(remarks, (TransformMeta)this.transformMeta, (IVariables)this.variables, (String)"IDENTIFIER", (String)"true");
        TransformOption.checkBoolean(remarks, (TransformMeta)this.transformMeta, (IVariables)this.variables, (String)"IDENTIFIER", (String)"false");
        Assert.assertEquals((long)0L, (long)remarks.size());
    }

    @Test
    public void testCheckPassEmpty() {
        ArrayList remarks = new ArrayList();
        TransformOption.checkInteger(remarks, (TransformMeta)this.transformMeta, (IVariables)this.variables, (String)"IDENTIFIER", (String)"");
        TransformOption.checkLong(remarks, (TransformMeta)this.transformMeta, (IVariables)this.variables, (String)"IDENTIFIER", (String)"");
        TransformOption.checkBoolean(remarks, (TransformMeta)this.transformMeta, (IVariables)this.variables, (String)"IDENTIFIER", (String)"");
        TransformOption.checkInteger(remarks, (TransformMeta)this.transformMeta, (IVariables)this.variables, (String)"IDENTIFIER", null);
        TransformOption.checkLong(remarks, (TransformMeta)this.transformMeta, (IVariables)this.variables, (String)"IDENTIFIER", null);
        TransformOption.checkBoolean(remarks, (TransformMeta)this.transformMeta, (IVariables)this.variables, (String)"IDENTIFIER", null);
        Assert.assertEquals((long)0L, (long)remarks.size());
    }

    @Test
    public void testCheckFailInteger() {
        ArrayList remarks = new ArrayList();
        TransformOption.checkInteger(remarks, (TransformMeta)this.transformMeta, (IVariables)this.variables, (String)"IDENTIFIER", (String)"asdf");
        Assert.assertEquals((long)1L, (long)remarks.size());
        Assert.assertEquals((Object)((ICheckResult)remarks.get(0)).getText(), (Object)BaseMessages.getString(TransformOption.class, (String)"TransformOption.CheckResult.NotAInteger", (String[])new String[]{"IDENTIFIER"}));
    }

    @Test
    public void testCheckFailLong() {
        ArrayList remarks = new ArrayList();
        TransformOption.checkLong(remarks, (TransformMeta)this.transformMeta, (IVariables)this.variables, (String)"IDENTIFIER", (String)"asdf");
        Assert.assertEquals((long)1L, (long)remarks.size());
        Assert.assertEquals((Object)((ICheckResult)remarks.get(0)).getText(), (Object)BaseMessages.getString(TransformOption.class, (String)"TransformOption.CheckResult.NotAInteger", (String[])new String[]{"IDENTIFIER"}));
    }

    @Test
    public void testCheckFailBoolean() {
        ArrayList remarks = new ArrayList();
        TransformOption.checkBoolean(remarks, (TransformMeta)this.transformMeta, (IVariables)this.variables, (String)"IDENTIFIER", (String)"asdf");
        Assert.assertEquals((long)1L, (long)remarks.size());
        Assert.assertEquals((Object)((ICheckResult)remarks.get(0)).getText(), (Object)BaseMessages.getString(TransformOption.class, (String)"TransformOption.CheckResult.NotABoolean", (String[])new String[]{"IDENTIFIER"}));
    }
}

