/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transform;

import java.io.InputStream;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.serializer.memory.MemoryMetadataProvider;
import org.apache.hop.metadata.serializer.xml.XmlMetadataUtil;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.junit.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class TransformSerializationTestUtil {
    public static final <T extends ITransformMeta> T testSerialization(String filename, Class<T> clazz) throws Exception {
        return TransformSerializationTestUtil.testSerialization(filename, clazz, "transform", (IHopMetadataProvider)new MemoryMetadataProvider());
    }

    public static final <T extends ITransformMeta> T testSerialization(String filename, Class<T> clazz, IHopMetadataProvider metadataProvider) throws Exception {
        return TransformSerializationTestUtil.testSerialization(filename, clazz, "transform", metadataProvider);
    }

    public static final <T extends ITransformMeta> T testSerialization(String filename, Class<T> clazz, String xmlTag, IHopMetadataProvider metadataProvider) throws Exception {
        Document document = XmlHandler.loadXmlFile((InputStream)clazz.getResourceAsStream(filename));
        Node node = XmlHandler.getSubNode((Node)document, (String)xmlTag);
        ITransformMeta meta = (ITransformMeta)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        XmlMetadataUtil.deSerializeFromXml(null, (Node)node, clazz, (Object)meta, (IHopMetadataProvider)metadataProvider);
        String xml = XmlHandler.openTag((String)xmlTag) + meta.getXml() + XmlHandler.closeTag((String)xmlTag);
        Document copyDocument = XmlHandler.loadXmlString((String)xml);
        Node copyNode = XmlHandler.getSubNode((Node)copyDocument, (String)xmlTag);
        ITransformMeta copy = (ITransformMeta)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        XmlMetadataUtil.deSerializeFromXml(null, (Node)copyNode, clazz, (Object)copy, (IHopMetadataProvider)metadataProvider);
        Assert.assertEquals((Object)meta.getXml(), (Object)copy.getXml());
        return (T)meta;
    }
}

