/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.loadsave;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hop.base.LoadSaveBase;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.loadsave.getter.IGetter;
import org.apache.hop.pipeline.transforms.loadsave.initializer.IInitializer;
import org.apache.hop.pipeline.transforms.loadsave.setter.ISetter;
import org.apache.hop.pipeline.transforms.loadsave.validator.DatabaseMetaLoadSaveValidator;
import org.apache.hop.pipeline.transforms.loadsave.validator.IFieldLoadSaveValidator;
import org.apache.hop.pipeline.transforms.loadsave.validator.IFieldLoadSaveValidatorFactory;
import org.junit.Assert;
import org.w3c.dom.Node;

public class LoadSaveTester<T extends ITransformMeta>
extends LoadSaveBase<T> {
    public LoadSaveTester(Class<T> clazz, List<String> attributes, Map<String, String> getterMap, Map<String, String> setterMap, Map<String, IFieldLoadSaveValidator<?>> fieldLoadSaveValidatorAttributeMap, Map<String, IFieldLoadSaveValidator<?>> fieldLoadSaveValidatorTypeMap, IInitializer<T> metaInitializerIFace) throws HopException {
        super(clazz, attributes, getterMap, setterMap, fieldLoadSaveValidatorAttributeMap, fieldLoadSaveValidatorTypeMap, metaInitializerIFace);
    }

    public LoadSaveTester(Class<T> clazz, List<String> attributes, Map<String, String> getterMap, Map<String, String> setterMap, Map<String, IFieldLoadSaveValidator<?>> fieldLoadSaveValidatorAttributeMap, Map<String, IFieldLoadSaveValidator<?>> fieldLoadSaveValidatorTypeMap) throws HopException {
        this(clazz, attributes, getterMap, setterMap, fieldLoadSaveValidatorAttributeMap, fieldLoadSaveValidatorTypeMap, null);
    }

    public LoadSaveTester(Class<T> clazz, List<String> attributes, Map<String, String> getterMap, Map<String, String> setterMap) throws HopException {
        this(clazz, attributes, getterMap, setterMap, new HashMap(), new HashMap());
    }

    public LoadSaveTester(Class<T> clazz, List<String> attributes) throws HopException {
        this(clazz, attributes, new HashMap<String, String>(), new HashMap<String, String>());
    }

    public LoadSaveTester(Class<T> clazz) throws HopException {
        this(clazz, new ArrayList<String>());
    }

    @Override
    public IFieldLoadSaveValidatorFactory getFieldLoadSaveValidatorFactory() {
        return this.fieldLoadSaveValidatorFactory;
    }

    @Override
    protected Map<String, IFieldLoadSaveValidator<?>> createValidatorMapAndInvokeSetters(List<String> attributes, T metaToSave) {
        HashMap validatorMap = new HashMap();
        for (String attribute : attributes) {
            IGetter<?> getter = this.manipulator.getGetter(attribute);
            ISetter<?> setter = this.manipulator.getSetter(attribute);
            IFieldLoadSaveValidator<?> validator = this.fieldLoadSaveValidatorFactory.createValidator(getter);
            try {
                Object testValue = validator.getTestObject();
                setter.set(metaToSave, testValue);
                if (validator instanceof DatabaseMetaLoadSaveValidator) {
                    this.addDatabase((DatabaseMeta)testValue);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to invoke setter for " + attribute, e);
            }
            validatorMap.put(attribute, validator);
        }
        return validatorMap;
    }

    public void testSerialization() throws HopException {
        this.testXmlRoundTrip();
        this.testClone();
    }

    protected void testClone() throws HopException {
        ITransformMeta metaToSave = (ITransformMeta)this.createMeta();
        if (this.initializer != null) {
            this.initializer.modify(metaToSave);
        }
        Map<String, IFieldLoadSaveValidator<?>> validatorMap = this.createValidatorMapAndInvokeSetters((List<String>)this.attributes, metaToSave);
        ITransformMeta metaLoaded = (ITransformMeta)metaToSave.clone();
        Assert.assertNotSame((Object)metaToSave, (Object)metaLoaded);
        this.validateLoadedMeta(this.attributes, validatorMap, metaToSave, metaLoaded);
    }

    @Deprecated(since="2.0")
    public void testXmlRoundTrip() throws HopException {
        ITransformMeta metaToSave = (ITransformMeta)this.createMeta();
        if (this.initializer != null) {
            this.initializer.modify(metaToSave);
        }
        Map<String, IFieldLoadSaveValidator<?>> validatorMap = this.createValidatorMapAndInvokeSetters((List<String>)this.attributes, metaToSave);
        ITransformMeta metaLoaded = (ITransformMeta)this.createMeta();
        String xml = "<transform>" + metaToSave.getXml() + "</transform>";
        ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes());
        metaLoaded.loadXml(XmlHandler.getSubNode((Node)XmlHandler.loadXmlFile((InputStream)is, null, (boolean)false, (boolean)false), (String)"transform"), this.metadataProvider);
        this.validateLoadedMeta(this.attributes, validatorMap, metaToSave, metaLoaded);
        this.testClone();
    }
}

