/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.loadsave.validator;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.pipeline.transforms.loadsave.getter.IGetter;
import org.apache.hop.pipeline.transforms.loadsave.validator.ArrayLoadSaveValidator;
import org.apache.hop.pipeline.transforms.loadsave.validator.BooleanLoadSaveValidator;
import org.apache.hop.pipeline.transforms.loadsave.validator.DatabaseMetaLoadSaveValidator;
import org.apache.hop.pipeline.transforms.loadsave.validator.DateLoadSaveValidator;
import org.apache.hop.pipeline.transforms.loadsave.validator.IFieldLoadSaveValidator;
import org.apache.hop.pipeline.transforms.loadsave.validator.IFieldLoadSaveValidatorFactory;
import org.apache.hop.pipeline.transforms.loadsave.validator.IntLoadSaveValidator;
import org.apache.hop.pipeline.transforms.loadsave.validator.ListLoadSaveValidator;
import org.apache.hop.pipeline.transforms.loadsave.validator.LocaleLoadSaveValidator;
import org.apache.hop.pipeline.transforms.loadsave.validator.LongLoadSaveValidator;
import org.apache.hop.pipeline.transforms.loadsave.validator.PrimitiveBooleanArrayLoadSaveValidator;
import org.apache.hop.pipeline.transforms.loadsave.validator.PrimitiveIntArrayLoadSaveValidator;
import org.apache.hop.pipeline.transforms.loadsave.validator.StringLoadSaveValidator;

public class DefaultFieldLoadSaveValidatorFactory
implements IFieldLoadSaveValidatorFactory {
    private final Map<IGetter<?>, IFieldLoadSaveValidator<?>> getterMap;
    private final Map<String, IFieldLoadSaveValidator<?>> typeMap = new HashMap();

    public DefaultFieldLoadSaveValidatorFactory() {
        this.getterMap = new HashMap();
        this.typeMap.put(String.class.getCanonicalName(), new StringLoadSaveValidator());
        this.typeMap.put(Boolean.TYPE.getCanonicalName(), new BooleanLoadSaveValidator());
        this.typeMap.put(Boolean.class.getCanonicalName(), new BooleanLoadSaveValidator());
        this.typeMap.put(Integer.TYPE.getCanonicalName(), new IntLoadSaveValidator());
        this.typeMap.put(Long.TYPE.getCanonicalName(), new LongLoadSaveValidator());
        this.registerValidator(this.getName(List.class, String.class), new ListLoadSaveValidator<String>((IFieldLoadSaveValidator)new StringLoadSaveValidator()){});
        this.registerValidator(String[].class.getCanonicalName(), new ArrayLoadSaveValidator<String>(new StringLoadSaveValidator()));
        this.registerValidator(boolean[].class.getCanonicalName(), new PrimitiveBooleanArrayLoadSaveValidator(new BooleanLoadSaveValidator()));
        this.registerValidator(Boolean[].class.getCanonicalName(), new ArrayLoadSaveValidator<Boolean>(new BooleanLoadSaveValidator()));
        this.registerValidator(int[].class.getCanonicalName(), new PrimitiveIntArrayLoadSaveValidator(new IntLoadSaveValidator()));
        this.registerValidator(Locale.class.getCanonicalName(), new LocaleLoadSaveValidator());
        this.registerValidator(DatabaseMeta.class.getCanonicalName(), new DatabaseMetaLoadSaveValidator());
        this.registerValidator(DatabaseMeta[].class.getCanonicalName(), new ArrayLoadSaveValidator<DatabaseMeta>(new DatabaseMetaLoadSaveValidator()));
        this.registerValidator(Date.class.getCanonicalName(), new DateLoadSaveValidator());
    }

    @Override
    public void registerValidator(String typeString, IFieldLoadSaveValidator<?> validator) {
        this.typeMap.put(typeString, validator);
    }

    public DefaultFieldLoadSaveValidatorFactory(Map<IGetter<?>, IFieldLoadSaveValidator<?>> map, Map<String, IFieldLoadSaveValidator<?>> fieldLoadSaveValidatorTypeMap) {
        this();
        this.getterMap.putAll(map);
        this.typeMap.putAll(fieldLoadSaveValidatorTypeMap);
    }

    @Override
    public <T> IFieldLoadSaveValidator<T> createValidator(IGetter<T> getter) {
        try {
            IFieldLoadSaveValidator<?> validatorClass = this.getterMap.get(getter);
            if (validatorClass == null) {
                Type type = getter.getGenericType();
                validatorClass = this.typeMap.get(this.getName(type));
            }
            if (validatorClass == null) {
                throw new RuntimeException("Unable to find validator for " + getter.getGenericType() + " or " + getter);
            }
            return validatorClass;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getName(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getCanonicalName();
        }
        ParameterizedType type2 = (ParameterizedType)type;
        return this.getName(type2.getRawType()) + this.getName(type2.getActualTypeArguments());
    }

    private Object getName(Type[] actualTypeArguments) {
        StringBuilder sb = new StringBuilder();
        if (actualTypeArguments.length > 0) {
            sb.append("<");
            for (Type parameter : actualTypeArguments) {
                sb.append(this.getName(parameter));
                sb.append(",");
            }
            sb.setLength(sb.length() - 1);
            sb.append(">");
        }
        return sb.toString();
    }

    @Override
    public String getName(Class<?> type, Class<?> ... parameters) {
        StringBuilder sb = new StringBuilder(type.getCanonicalName());
        if (parameters.length > 0) {
            sb.append("<");
            for (Class<?> parameter : parameters) {
                sb.append(parameter.getCanonicalName());
                sb.append(",");
            }
            sb.setLength(sb.length() - 1);
            sb.append(">");
        }
        return sb.toString();
    }
}

