/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.loadsave.validator;

import java.util.Random;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.pipeline.transforms.loadsave.validator.IFieldLoadSaveValidator;

public class PrimitiveBooleanArrayLoadSaveValidator
implements IFieldLoadSaveValidator<boolean[]> {
    private final IFieldLoadSaveValidator<Boolean> validator;
    private final Integer elements;

    public PrimitiveBooleanArrayLoadSaveValidator(IFieldLoadSaveValidator<Boolean> fieldValidator) {
        this(fieldValidator, null);
    }

    public PrimitiveBooleanArrayLoadSaveValidator(IFieldLoadSaveValidator<Boolean> fieldValidator, Integer elements) {
        this.validator = fieldValidator;
        this.elements = elements;
    }

    @Override
    public boolean[] getTestObject() {
        int max = this.elements == null ? new Random().nextInt(100) + 50 : this.elements;
        boolean[] result = new boolean[max];
        for (int i = 0; i < max; ++i) {
            result[i] = this.validator.getTestObject();
        }
        return result;
    }

    @Override
    public boolean validateTestObject(boolean[] original, Object actual) throws HopException {
        if (original.getClass().isAssignableFrom(actual.getClass())) {
            boolean[] otherList = (boolean[])actual;
            if (original.length != otherList.length) {
                return false;
            }
            for (int i = 0; i < original.length; ++i) {
                if (this.validator.validateTestObject(original[i], otherList[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

