/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.mock;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hop.core.IRowSet;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.ILogChannelFactory;
import org.apache.hop.core.logging.ILogMessage;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engines.local.LocalPipelineEngine;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class TransformMockHelper<Meta extends ITransformMeta, Data extends ITransformData> {
    public final TransformMeta transformMeta;
    public final Data iTransformData;
    public final Meta iTransformMeta;
    public final PipelineMeta pipelineMeta;
    public final Pipeline pipeline;
    public final ILogChannel iLogChannel;
    public final ILogChannelFactory logChannelFactory;
    public final ILogChannelFactory originalLogChannelFactory = HopLogStore.getLogChannelFactory();

    public TransformMockHelper(String transformName, Class<Meta> transformMetaClass, Class<Data> transformDataClass) {
        this.logChannelFactory = (ILogChannelFactory)Mockito.mock(ILogChannelFactory.class);
        this.iLogChannel = (ILogChannel)Mockito.mock(ILogChannel.class);
        HopLogStore.setLogChannelFactory((ILogChannelFactory)this.logChannelFactory);
        this.transformMeta = (TransformMeta)Mockito.mock(TransformMeta.class);
        Mockito.when((Object)this.transformMeta.getName()).thenReturn((Object)transformName);
        this.iTransformData = (ITransformData)Mockito.mock(transformDataClass);
        this.iTransformMeta = (ITransformMeta)Mockito.mock(transformMetaClass);
        this.pipelineMeta = (PipelineMeta)Mockito.mock(PipelineMeta.class);
        Mockito.when((Object)this.pipelineMeta.findTransform(transformName)).thenReturn((Object)this.transformMeta);
        this.pipeline = (Pipeline)Mockito.spy((Object)new LocalPipelineEngine());
    }

    public IRowSet getMockInputRowSet(Object[] ... rows) {
        return this.getMockInputRowSet(TransformMockHelper.asList(rows));
    }

    public IRowSet getMockInputRowSet(List<Object[]> rows) {
        AtomicInteger index = new AtomicInteger(0);
        IRowSet rowSet = (IRowSet)Mockito.mock(IRowSet.class, (Answer)Mockito.RETURNS_MOCKS);
        Answer answer = invocation -> {
            int i = index.getAndIncrement();
            return i < rows.size() ? (Object[])rows.get(i) : null;
        };
        Mockito.when((Object)rowSet.getRowWait(ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)))).thenAnswer(answer);
        Mockito.when((Object)rowSet.getRow()).thenAnswer(answer);
        Mockito.when((Object)rowSet.isDone()).thenAnswer(invocation -> index.get() >= rows.size());
        IRowMeta rowMeta = (IRowMeta)Mockito.mock(IRowMeta.class);
        Mockito.when((Object)rowMeta.clone()).thenReturn((Object)((IRowMeta)Mockito.mock(IRowMeta.class)));
        Mockito.when((Object)rowSet.getRowMeta()).thenReturn((Object)rowMeta);
        return rowSet;
    }

    public static List<Object[]> asList(Object[] ... objects) {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        Collections.addAll(result, objects);
        return result;
    }

    public void cleanUp() {
        HopLogStore.setLogChannelFactory((ILogChannelFactory)this.originalLogChannelFactory);
    }

    public void redirectLog(OutputStream out, LogLevel channelLogLevel) {
        LogChannel log = (LogChannel)Mockito.spy((Object)new LogChannel((Object)this.getClass().getName(), true));
        log.setLogLevel(channelLogLevel);
        Mockito.when((Object)this.logChannelFactory.create(ArgumentMatchers.any(), (ILoggingObject)ArgumentMatchers.any(ILoggingObject.class))).thenReturn((Object)log);
        ((LogChannel)Mockito.doAnswer(invocation -> {
            LogLevel channelLogLevel1;
            Object[] args = invocation.getArguments();
            LogLevel logLevel = (LogLevel)args[1];
            if (!logLevel.isVisible(channelLogLevel1 = log.getLogLevel())) {
                return null;
            }
            if (channelLogLevel1.getLevel() >= logLevel.getLevel()) {
                ILogMessage logMessage = (ILogMessage)args[0];
                out.write(logMessage.getMessage().getBytes());
                out.write(10);
                out.write(13);
                out.flush();
                return true;
            }
            return false;
        }).when((Object)log)).println((ILogMessage)ArgumentMatchers.any(), (LogLevel)ArgumentMatchers.any(LogLevel.class));
    }
}

