/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.server;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.hop.core.Const;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.encryption.TwoWayPasswordEncoderPluginType;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.plugins.IPluginType;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.util.EnvUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.server.HopServer;
import org.apache.hop.server.ServerConnectionManager;
import org.apache.hop.utils.TestUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class HopServerTest {
    HopServer hopServer;
    IVariables variables;

    @BeforeClass
    public static void beforeClass() throws HopException {
        PluginRegistry.addPluginType((IPluginType)TwoWayPasswordEncoderPluginType.getInstance());
        PluginRegistry.init();
        String passwordEncoderPluginID = Const.NVL((String)EnvUtil.getSystemProperty((String)"HOP_PASSWORD_ENCODER_PLUGIN"), (String)"Hop");
        Encr.init((String)passwordEncoderPluginID);
    }

    @AfterClass
    public static void tearDown() {
        PluginRegistry.getInstance().reset();
    }

    @Before
    public void init() throws Exception {
        ServerConnectionManager connectionManager = ServerConnectionManager.getInstance();
        HttpClient httpClient = (HttpClient)Mockito.spy((Object)connectionManager.createHttpClient());
        CloseableHttpResponse closeableHttpResponseMock = (CloseableHttpResponse)Mockito.mock(CloseableHttpResponse.class);
        StatusLine statusLineMock = (StatusLine)Mockito.mock(StatusLine.class);
        ((StatusLine)Mockito.doReturn((Object)404).when((Object)statusLineMock)).getStatusCode();
        ((CloseableHttpResponse)Mockito.doReturn((Object)statusLineMock).when((Object)closeableHttpResponseMock)).getStatusLine();
        HttpEntity httpEntityMock = (HttpEntity)Mockito.mock(HttpEntity.class);
        ((CloseableHttpResponse)Mockito.doReturn((Object)httpEntityMock).when((Object)closeableHttpResponseMock)).getEntity();
        ((HttpClient)Mockito.doReturn((Object)closeableHttpResponseMock).when((Object)httpClient)).execute((HttpUriRequest)ArgumentMatchers.any(HttpGet.class));
        ((HttpClient)Mockito.doReturn((Object)closeableHttpResponseMock).when((Object)httpClient)).execute((HttpUriRequest)ArgumentMatchers.any(HttpPost.class));
        ((HttpClient)Mockito.doReturn((Object)closeableHttpResponseMock).when((Object)httpClient)).execute((HttpUriRequest)ArgumentMatchers.any(HttpPost.class), (HttpContext)ArgumentMatchers.nullable(HttpClientContext.class));
        this.hopServer = (HopServer)Mockito.spy((Object)new HopServer());
        this.variables = new Variables();
        ((HopServer)Mockito.doReturn((Object)httpClient).when((Object)this.hopServer)).getHttpClient();
        ((HopServer)Mockito.doReturn((Object)"response_body").when((Object)this.hopServer)).getResponseBodyAsString((InputStream)ArgumentMatchers.nullable(InputStream.class));
    }

    private HttpResponse mockResponse(int statusCode, String entityText) throws IOException {
        HttpResponse resp = (HttpResponse)Mockito.mock(HttpResponse.class);
        StatusLine status = (StatusLine)Mockito.mock(StatusLine.class);
        Mockito.when((Object)status.getStatusCode()).thenReturn((Object)statusCode);
        Mockito.when((Object)resp.getStatusLine()).thenReturn((Object)status);
        HttpEntity entity = (HttpEntity)Mockito.mock(HttpEntity.class);
        Mockito.when((Object)entity.getContent()).thenReturn((Object)new ByteArrayInputStream(entityText.getBytes(StandardCharsets.UTF_8)));
        Mockito.when((Object)resp.getEntity()).thenReturn((Object)entity);
        return resp;
    }

    @Test(expected=HopException.class)
    public void testExecService() throws Exception {
        String nonExistingAppName = "wrong_app_name";
        HttpGet httpGetMock = (HttpGet)Mockito.mock(HttpGet.class);
        URI uriMock = new URI(nonExistingAppName);
        ((HttpGet)Mockito.doReturn((Object)uriMock).when((Object)httpGetMock)).getURI();
        HttpClient clientMock = (HttpClient)Mockito.mock(HttpClient.class);
        Mockito.when((Object)clientMock.execute((HttpUriRequest)ArgumentMatchers.any(HttpUriRequest.class), (HttpContext)ArgumentMatchers.any(HttpContext.class))).then(invocation -> {
            HttpUriRequest request = (HttpUriRequest)invocation.getArgument(0);
            if (request.getURI().equals(uriMock)) {
                return this.mockResponse(404, "");
            }
            return this.mockResponse(200, "");
        });
        Mockito.when((Object)this.hopServer.getHttpClient()).thenReturn((Object)clientMock);
        ((HopServer)Mockito.doReturn((Object)httpGetMock).when((Object)this.hopServer)).buildExecuteServiceMethod((IVariables)ArgumentMatchers.any(IVariables.class), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap());
        this.hopServer.setHostname("hostNameStub");
        this.hopServer.setUsername("userNAmeStub");
        this.hopServer.execService(Variables.getADefaultVariableSpace(), nonExistingAppName);
        Assert.fail((String)"Incorrect connection details had been used, but no exception was thrown");
    }

    @Test(expected=HopException.class)
    public void testSendXml() throws Exception {
        this.hopServer.setHostname("hostNameStub");
        this.hopServer.setUsername("userNAmeStub");
        HttpPost httpPostMock = (HttpPost)Mockito.mock(HttpPost.class);
        URI uriMock = new URI("fake");
        ((HttpPost)Mockito.doReturn((Object)uriMock).when((Object)httpPostMock)).getURI();
        ((HopServer)Mockito.doReturn((Object)httpPostMock).when((Object)this.hopServer)).buildSendXmlMethod((IVariables)ArgumentMatchers.any(Variables.class), (byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.anyString());
        this.hopServer.sendXml(this.variables, "", "");
        Assert.fail((String)"Incorrect connection details had been used, but no exception was thrown");
    }

    @Test(expected=HopException.class)
    public void testSendExport() throws Exception {
        this.hopServer.setHostname("hostNameStub");
        this.hopServer.setUsername("userNAmeStub");
        HttpPost httpPostMock = (HttpPost)Mockito.mock(HttpPost.class);
        URI uriMock = new URI("fake");
        ((HttpPost)Mockito.doReturn((Object)uriMock).when((Object)httpPostMock)).getURI();
        ((HopServer)Mockito.doReturn((Object)httpPostMock).when((Object)this.hopServer)).buildSendExportMethod((IVariables)ArgumentMatchers.any(Variables.class), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (InputStream)ArgumentMatchers.any(InputStream.class));
        File tempFile = File.createTempFile("ApacheHop-", "tmp");
        tempFile.deleteOnExit();
        this.hopServer.sendExport(this.variables, tempFile.getAbsolutePath(), "", "");
        Assert.fail((String)"Incorrect connection details had been used, but no exception was thrown");
    }

    @Test
    public void testSendExportOk() throws Exception {
        this.hopServer.setUsername("uname");
        this.hopServer.setPassword("passw");
        this.hopServer.setHostname("hname");
        this.hopServer.setPort("1111");
        HttpPost httpPostMock = (HttpPost)Mockito.mock(HttpPost.class);
        URI uriMock = new URI("fake");
        String responseContent = "baah";
        Mockito.when((Object)httpPostMock.getURI()).thenReturn((Object)uriMock);
        ((HttpPost)Mockito.doReturn((Object)uriMock).when((Object)httpPostMock)).getURI();
        HttpClient client = (HttpClient)Mockito.mock(HttpClient.class);
        Mockito.when((Object)client.execute((HttpUriRequest)ArgumentMatchers.any(), (HttpContext)ArgumentMatchers.any(HttpContext.class))).then(invocation -> {
            HttpClientContext context = (HttpClientContext)invocation.getArguments()[1];
            Credentials cred = context.getCredentialsProvider().getCredentials(new AuthScope("hname", 1111));
            Assert.assertEquals((Object)"uname", (Object)cred.getUserPrincipal().getName());
            return this.mockResponse(200, "baah");
        });
        Mockito.when((Object)this.hopServer.getHttpClient()).thenReturn((Object)client);
        Mockito.when((Object)this.hopServer.getResponseBodyAsString((InputStream)ArgumentMatchers.any())).thenCallRealMethod();
        ((HopServer)Mockito.doReturn((Object)httpPostMock).when((Object)this.hopServer)).buildSendExportMethod((IVariables)ArgumentMatchers.any(Variables.class), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (InputStream)ArgumentMatchers.any(InputStream.class));
        File tempFile = File.createTempFile("ApacheHop-", "tmp");
        tempFile.deleteOnExit();
        String result = this.hopServer.sendExport(this.variables, tempFile.getAbsolutePath(), null, null);
        Assert.assertEquals((Object)"baah", (Object)result);
    }

    @Test
    public void testAddCredentials() throws IOException, ClassNotFoundException {
        String testUser = "test_username";
        this.hopServer.setUsername(testUser);
        String testPassword = "test_password";
        this.hopServer.setPassword(testPassword);
        String host = "somehost";
        this.hopServer.setHostname(host);
        int port = 1000;
        this.hopServer.setPort("" + port);
        HttpClientContext auth = this.hopServer.getAuthContext(this.variables);
        Credentials cred = auth.getCredentialsProvider().getCredentials(new AuthScope(host, port));
        Assert.assertEquals((Object)testUser, (Object)cred.getUserPrincipal().getName());
        Assert.assertEquals((Object)testPassword, (Object)cred.getPassword());
        String user2 = "user2";
        this.hopServer.setUsername(user2);
        this.hopServer.setPassword("pass2");
        auth = this.hopServer.getAuthContext(this.variables);
        cred = auth.getCredentialsProvider().getCredentials(new AuthScope(host, port));
        Assert.assertEquals((Object)user2, (Object)cred.getUserPrincipal().getName());
    }

    @Test
    public void testAuthCredentialsSchemeWithSSL() {
        this.hopServer.setUsername("admin");
        this.hopServer.setPassword("password");
        this.hopServer.setHostname("localhost");
        this.hopServer.setPort("8443");
        this.hopServer.setSslMode(true);
        AuthCache cache = this.hopServer.getAuthContext(this.variables).getAuthCache();
        Assert.assertNotNull((Object)cache.get(new HttpHost("localhost", 8443, "https")));
        Assert.assertNull((Object)cache.get(new HttpHost("localhost", 8443, "http")));
    }

    @Test
    public void testAuthCredentialsSchemeWithoutSSL() {
        this.hopServer.setUsername("admin");
        this.hopServer.setPassword("password");
        this.hopServer.setHostname("localhost");
        this.hopServer.setPort("8080");
        this.hopServer.setSslMode(false);
        AuthCache cache = this.hopServer.getAuthContext(this.variables).getAuthCache();
        Assert.assertNull((Object)cache.get(new HttpHost("localhost", 8080, "https")));
        Assert.assertNotNull((Object)cache.get(new HttpHost("localhost", 8080, "http")));
    }

    @Test
    public void testModifyingName() {
        this.hopServer.setName("test");
        ArrayList<HopServer> list = new ArrayList<HopServer>();
        list.add(this.hopServer);
        HopServer hopServer2 = (HopServer)Mockito.spy((Object)new HopServer());
        hopServer2.setName("test");
        hopServer2.verifyAndModifyHopServerName(list, null);
        Assert.assertTrue((!this.hopServer.getName().equals(hopServer2.getName()) ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsHashCodeConsistency() throws Exception {
        HopServer server = new HopServer();
        server.setName("server");
        TestUtils.checkEqualsHashCodeConsistency(server, server);
        HopServer serverSame = new HopServer();
        serverSame.setName("server");
        Assert.assertTrue((boolean)server.equals((Object)serverSame));
        TestUtils.checkEqualsHashCodeConsistency(server, serverSame);
        HopServer serverCaps = new HopServer();
        serverCaps.setName("SERVER");
        TestUtils.checkEqualsHashCodeConsistency(server, serverCaps);
        HopServer serverOther = new HopServer();
        serverOther.setName("something else");
        TestUtils.checkEqualsHashCodeConsistency(server, serverOther);
    }
}

