/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.utils;

import java.io.File;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.util.FileUtil;
import org.apache.hop.utils.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class FileUtilsTest {
    @Test
    public void testCreateTempDir() {
        String tempDir = TestUtils.createTempDir();
        if (tempDir != null) {
            File fl = new File(tempDir);
            Assert.assertTrue((String)"Dir should be created", (boolean)fl.exists());
            try {
                fl.delete();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Test
    public void testCreateParentFolder() {
        Object tempDir = TestUtils.createTempDir();
        String suff = ((String)tempDir).substring(((String)tempDir).lastIndexOf(File.separator) + 1);
        tempDir = (String)tempDir + File.separator + suff + File.separator + suff;
        Assert.assertTrue((String)"Dir should be created", (boolean)FileUtil.createParentFolder(this.getClass(), (String)tempDir, (boolean)true, (ILogChannel)new LogChannel((Object)this)));
        File fl = new File(((String)tempDir).substring(0, ((String)tempDir).lastIndexOf(File.separator)));
        Assert.assertTrue((String)"Dir should exist", (boolean)fl.exists());
        fl.delete();
        new File((String)tempDir).delete();
    }

    @Test
    public void testIsFullyQualified() {
        Assert.assertTrue((boolean)FileUtil.isFullyQualified((String)"/test"));
        Assert.assertTrue((boolean)FileUtil.isFullyQualified((String)"\\test"));
    }
}

