/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.utils;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.core.vfs.HopVfs;
import org.junit.Assert;

public class TestUtils {
    @Deprecated(since="2.0")
    public static String createTempDir() {
        String ret = null;
        try {
            File file = File.createTempFile("temp_hop_test_dir", String.valueOf(System.currentTimeMillis()));
            file.delete();
            file.mkdir();
            file.deleteOnExit();
            ret = file.getAbsolutePath();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return ret;
    }

    public static File getInputFile(String prefix, String suffix) throws IOException {
        File inputFile = File.createTempFile(prefix, suffix);
        inputFile.deleteOnExit();
        FileUtils.writeStringToFile((File)inputFile, (String)UUID.randomUUID().toString(), (Charset)StandardCharsets.UTF_8);
        return inputFile;
    }

    public static String createRamFile(String path) {
        return TestUtils.createRamFile(path, null);
    }

    public static String createRamFile(String path, IVariables variables) {
        if (variables == null) {
            variables = new Variables();
            variables.initializeFrom(null);
        }
        try {
            FileObject file = HopVfs.getFileObject((String)("ram://" + path));
            file.createFile();
            return file.getName().getURI();
        }
        catch (FileSystemException | HopFileException e) {
            throw new RuntimeException(e);
        }
    }

    public static FileObject getFileObject(String vfsPath) {
        return TestUtils.getFileObject(vfsPath, null);
    }

    public static FileObject getFileObject(String vfsPath, IVariables variables) {
        if (variables == null) {
            variables = new Variables();
            variables.initializeFrom(null);
        }
        try {
            return HopVfs.getFileObject((String)vfsPath);
        }
        catch (HopFileException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toUnixLineSeparators(String string) {
        if (string != null) {
            string = string.replaceAll("\r", "");
        }
        return string;
    }

    public static void checkEqualsHashCodeConsistency(Object object1, Object object2) {
        if (object1.equals(object2)) {
            Assert.assertTrue((String)"inconsistent hashcode and equals", (object1.hashCode() == object2.hashCode() ? 1 : 0) != 0);
        }
    }
}

