/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow;

import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.hop.core.NotePadMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.listeners.IContentChangedListener;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.workflow.WorkflowHopMeta;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.actions.dummy.ActionDummy;
import org.apache.hop.workflow.engines.local.LocalWorkflowEngine;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WorkflowMetaTest {
    private static final String WORKFLOW_META_NAME = "workflowName";
    private WorkflowMeta workflowMeta;
    private IVariables variables;
    private IContentChangedListener listener;

    @Before
    public void setUp() {
        this.workflowMeta = new WorkflowMeta();
        this.workflowMeta.setNameSynchronizedWithFilename(false);
        this.listener = (IContentChangedListener)Mockito.mock(IContentChangedListener.class);
        this.workflowMeta.addContentChangedListener(this.listener);
        this.workflowMeta.setName(WORKFLOW_META_NAME);
        this.variables = new Variables();
    }

    @Test
    public void testPathExist() throws HopXmlException, IOException, URISyntaxException {
        Assert.assertTrue((boolean)this.testPath("je1-je4"));
    }

    @Test
    public void testPathNotExist() throws HopXmlException, IOException, URISyntaxException {
        Assert.assertFalse((boolean)this.testPath("je2-je4"));
    }

    private boolean testPath(String branch) {
        ActionDummy je1 = new ActionDummy();
        je1.setName("je1");
        ActionDummy je2 = new ActionDummy();
        je2.setName("je2");
        WorkflowHopMeta hop = new WorkflowHopMeta(new ActionMeta((IAction)je1), new ActionMeta((IAction)je2));
        this.workflowMeta.addWorkflowHop(hop);
        ActionDummy je3 = new ActionDummy();
        je3.setName("je3");
        hop = new WorkflowHopMeta(new ActionMeta((IAction)je1), new ActionMeta((IAction)je3));
        this.workflowMeta.addWorkflowHop(hop);
        ActionDummy je4 = new ActionDummy();
        je4.setName("je4");
        hop = new WorkflowHopMeta(new ActionMeta((IAction)je3), new ActionMeta((IAction)je4));
        this.workflowMeta.addWorkflowHop(hop);
        if (branch.equals("je1-je4")) {
            return this.workflowMeta.isPathExist((IAction)je1, (IAction)je4);
        }
        if (branch.equals("je2-je4")) {
            return this.workflowMeta.isPathExist((IAction)je2, (IAction)je4);
        }
        return false;
    }

    @Test
    public void testContentChangeListener() throws Exception {
        this.workflowMeta.setChanged();
        this.workflowMeta.setChanged(true);
        ((IContentChangedListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.times((int)2))).contentChanged(Matchers.same((Object)this.workflowMeta));
        this.workflowMeta.clearChanged();
        this.workflowMeta.setChanged(false);
        ((IContentChangedListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.times((int)2))).contentSafe(Matchers.same((Object)this.workflowMeta));
        this.workflowMeta.removeContentChangedListener(this.listener);
        this.workflowMeta.setChanged();
        this.workflowMeta.setChanged(true);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.listener});
    }

    @Test
    public void shouldUseCoordinatesOfItsTransformsAndNotesWhenCalculatingMinimumPoint() {
        Point actionPoint = new Point(500, 500);
        Point notePadMetaPoint = new Point(400, 400);
        ActionMeta actionMeta = (ActionMeta)Mockito.mock(ActionMeta.class);
        Mockito.when((Object)actionMeta.getLocation()).thenReturn((Object)actionPoint);
        NotePadMeta notePadMeta = (NotePadMeta)Mockito.mock(NotePadMeta.class);
        Mockito.when((Object)notePadMeta.getLocation()).thenReturn((Object)notePadMetaPoint);
        Point point = this.workflowMeta.getMinimum();
        Assert.assertEquals((long)0L, (long)point.x);
        Assert.assertEquals((long)0L, (long)point.y);
        this.workflowMeta.addAction(0, actionMeta);
        Point actualTransformPoint = this.workflowMeta.getMinimum();
        Assert.assertEquals((long)(actionPoint.x - 20), (long)actualTransformPoint.x);
        Assert.assertEquals((long)(actionPoint.y - 20), (long)actualTransformPoint.y);
        this.workflowMeta.addNote(notePadMeta);
        Point transformPoint = this.workflowMeta.getMinimum();
        Assert.assertEquals((long)(notePadMetaPoint.x - 20), (long)transformPoint.x);
        Assert.assertEquals((long)(notePadMetaPoint.y - 20), (long)transformPoint.y);
    }

    @Test
    public void testEquals_oneNameNull() {
        Assert.assertFalse((boolean)this.testEquals(null, null));
    }

    @Test
    public void testEquals_secondNameNull() {
        this.workflowMeta.setName(null);
        Assert.assertFalse((boolean)this.testEquals(WORKFLOW_META_NAME, null));
    }

    @Test
    public void testEquals_sameFilename() {
        String newFilename = "Filename";
        this.workflowMeta.setFilename(newFilename);
        Assert.assertFalse((boolean)this.testEquals(null, newFilename));
    }

    @Test
    public void testEquals_difFilenameSameName() {
        this.workflowMeta.setFilename("Filename");
        Assert.assertFalse((boolean)this.testEquals(WORKFLOW_META_NAME, "OtherFileName"));
    }

    @Test
    public void testEquals_sameFilenameSameName() {
        String newFilename = "Filename";
        this.workflowMeta.setFilename(newFilename);
        Assert.assertTrue((boolean)this.testEquals(WORKFLOW_META_NAME, newFilename));
    }

    @Test
    public void testEquals_sameFilenameDifName() {
        String newFilename = "Filename";
        this.workflowMeta.setFilename(newFilename);
        Assert.assertFalse((boolean)this.testEquals("OtherName", newFilename));
    }

    private boolean testEquals(String name, String filename) {
        WorkflowMeta workflowMeta2 = new WorkflowMeta();
        workflowMeta2.setNameSynchronizedWithFilename(false);
        workflowMeta2.setName(name);
        workflowMeta2.setFilename(filename);
        return this.workflowMeta.equals((Object)workflowMeta2);
    }

    @Test
    public void testLoadXml() throws HopException {
        final String directory = "/home/admin";
        Node workflowNode = (Node)Mockito.mock(Node.class);
        NodeList nodeList = new NodeList(){
            Node node = (Node)Mockito.mock(Node.class);
            {
                Mockito.when((Object)this.node.getNodeName()).thenReturn((Object)"directory");
                Node child = (Node)Mockito.mock(Node.class);
                Mockito.when((Object)this.node.getFirstChild()).thenReturn((Object)child);
                Mockito.when((Object)child.getNodeValue()).thenReturn((Object)directory);
            }

            @Override
            public Node item(int index) {
                return this.node;
            }

            @Override
            public int getLength() {
                return 1;
            }
        };
        Mockito.when((Object)workflowNode.getChildNodes()).thenReturn((Object)nodeList);
        WorkflowMeta meta = new WorkflowMeta();
        meta.loadXml(workflowNode, null, (IHopMetadataProvider)Mockito.mock(IHopMetadataProvider.class), (IVariables)new Variables());
        LocalWorkflowEngine workflow = new LocalWorkflowEngine(meta);
        workflow.setInternalHopVariables();
    }

    @Test
    public void testAddRemoveJobEntryCopySetUnsetParent() throws Exception {
        ActionMeta actionCopy = (ActionMeta)Mockito.mock(ActionMeta.class);
        this.workflowMeta.addAction(actionCopy);
        this.workflowMeta.removeAction(0);
        ((ActionMeta)Mockito.verify((Object)actionCopy, (VerificationMode)Mockito.times((int)1))).setParentWorkflowMeta(this.workflowMeta);
        ((ActionMeta)Mockito.verify((Object)actionCopy, (VerificationMode)Mockito.times((int)1))).setParentWorkflowMeta(null);
    }

    @Test
    public void testHasLoop_simpleLoop() throws Exception {
        WorkflowMeta workflowMetaSpy = (WorkflowMeta)Mockito.spy((Object)this.workflowMeta);
        ActionMeta actionCopyMain = this.createAction("mainTransform");
        ActionMeta actionCopy2 = this.createAction("transform2");
        ActionMeta actionCopy3 = this.createAction("transform3");
        Mockito.when((Object)workflowMetaSpy.findNrPrevActions(actionCopyMain)).thenReturn((Object)1);
        Mockito.when((Object)workflowMetaSpy.findPrevAction(actionCopyMain, 0)).thenReturn((Object)actionCopy2);
        Mockito.when((Object)workflowMetaSpy.findNrPrevActions(actionCopy2)).thenReturn((Object)1);
        Mockito.when((Object)workflowMetaSpy.findPrevAction(actionCopy2, 0)).thenReturn((Object)actionCopy3);
        Mockito.when((Object)workflowMetaSpy.findNrPrevActions(actionCopy3)).thenReturn((Object)1);
        Mockito.when((Object)workflowMetaSpy.findPrevAction(actionCopy3, 0)).thenReturn((Object)actionCopyMain);
        Assert.assertTrue((boolean)workflowMetaSpy.hasLoop(actionCopyMain));
    }

    @Test
    public void testHasLoop_loopInPrevTransforms() throws Exception {
        WorkflowMeta workflowMetaSpy = (WorkflowMeta)Mockito.spy((Object)this.workflowMeta);
        ActionMeta actionCopyMain = this.createAction("mainTransform");
        ActionMeta actionCopy2 = this.createAction("transform2");
        ActionMeta actionCopy3 = this.createAction("transform3");
        ActionMeta actionCopy4 = this.createAction("transform4");
        Mockito.when((Object)workflowMetaSpy.findNrPrevActions(actionCopyMain)).thenReturn((Object)1);
        Mockito.when((Object)workflowMetaSpy.findPrevAction(actionCopyMain, 0)).thenReturn((Object)actionCopy2);
        Mockito.when((Object)workflowMetaSpy.findNrPrevActions(actionCopy2)).thenReturn((Object)1);
        Mockito.when((Object)workflowMetaSpy.findPrevAction(actionCopy2, 0)).thenReturn((Object)actionCopy3);
        Mockito.when((Object)workflowMetaSpy.findNrPrevActions(actionCopy3)).thenReturn((Object)1);
        Mockito.when((Object)workflowMetaSpy.findPrevAction(actionCopy3, 0)).thenReturn((Object)actionCopy4);
        Mockito.when((Object)workflowMetaSpy.findNrPrevActions(actionCopy4)).thenReturn((Object)1);
        Mockito.when((Object)workflowMetaSpy.findPrevAction(actionCopy4, 0)).thenReturn((Object)actionCopy3);
        Assert.assertFalse((boolean)workflowMetaSpy.hasLoop(actionCopyMain));
    }

    private ActionMeta createAction(String name) {
        IAction action = (IAction)Mockito.mock(IAction.class);
        ActionMeta actionMeta = new ActionMeta(action);
        Mockito.when((Object)actionMeta.getName()).thenReturn((Object)name);
        return actionMeta;
    }

    @Test
    public void testSetInternalEntryCurrentDirectoryWithFilename() {
        WorkflowMeta workflowMetaTest = new WorkflowMeta();
        workflowMetaTest.setFilename("hasFilename");
        this.variables.setVariable("Internal.Entry.Current.Folder", "Original value defined at run execution");
        this.variables.setVariable("Internal.Workflow.Filename.Folder", "file:///C:/SomeFilenameDirectory");
        workflowMetaTest.setInternalEntryCurrentDirectory(this.variables);
        Assert.assertEquals((Object)"file:///C:/SomeFilenameDirectory", (Object)this.variables.getVariable("Internal.Entry.Current.Folder"));
    }

    @Test
    public void testSetInternalEntryCurrentDirectoryWithoutFilename() {
        WorkflowMeta workflowMetaTest = new WorkflowMeta();
        this.variables.setVariable("Internal.Entry.Current.Folder", "Original value defined at run execution");
        this.variables.setVariable("Internal.Workflow.Filename.Folder", "file:///C:/SomeFilenameDirectory");
        workflowMetaTest.setInternalEntryCurrentDirectory(this.variables);
        Assert.assertEquals((Object)"Original value defined at run execution", (Object)this.variables.getVariable("Internal.Entry.Current.Folder"));
    }

    @Test
    public void testUpdateCurrentDirWithFilename() {
        WorkflowMeta workflowMetaTest = new WorkflowMeta();
        workflowMetaTest.setFilename("hasFilename");
        this.variables.setVariable("Internal.Entry.Current.Folder", "Original value defined at run execution");
        this.variables.setVariable("Internal.Workflow.Filename.Folder", "file:///C:/SomeFilenameDirectory");
        workflowMetaTest.updateCurrentDir(this.variables);
        Assert.assertEquals((Object)"file:///C:/SomeFilenameDirectory", (Object)this.variables.getVariable("Internal.Entry.Current.Folder"));
    }

    @Test
    public void testUpdateCurrentDirWithoutFilename() {
        WorkflowMeta workflowMetaTest = new WorkflowMeta();
        this.variables.setVariable("Internal.Entry.Current.Folder", "Original value defined at run execution");
        this.variables.setVariable("Internal.Workflow.Filename.Folder", "file:///C:/SomeFilenameDirectory");
        workflowMetaTest.updateCurrentDir(this.variables);
        Assert.assertEquals((Object)"Original value defined at run execution", (Object)this.variables.getVariable("Internal.Entry.Current.Folder"));
    }
}

