/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow;

import java.util.concurrent.CountDownLatch;
import org.apache.hop.core.HopEnvironment;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.workflow.Workflow;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionMeta;
import org.apache.hop.workflow.actions.start.ActionStart;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.apache.hop.workflow.engines.local.LocalWorkflowEngine;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class WorkflowTest {
    private static final String STRING_DEFAULT = "<def>";
    private IWorkflowEngine<WorkflowMeta> mockedWorkflow;
    private Database mockedDataBase;
    private IVariables mockedVariableSpace;
    private IHopMetadataProvider mockedMetadataProvider;
    private WorkflowMeta mockedWorkflowMeta;
    private ActionMeta mockedActionMeta;
    private ActionStart mockedActionStart;
    private LogChannel mockedLogChannel;
    int count = 10000;

    @BeforeClass
    public static void beforeClass() throws HopException {
        HopEnvironment.init();
    }

    @Before
    public void init() throws HopException {
        this.mockedDataBase = (Database)Mockito.mock(Database.class);
        this.mockedWorkflow = (IWorkflowEngine)Mockito.mock(Workflow.class);
        this.mockedVariableSpace = (IVariables)Mockito.mock(IVariables.class);
        this.mockedMetadataProvider = (IHopMetadataProvider)Mockito.mock(IHopMetadataProvider.class);
        this.mockedWorkflowMeta = (WorkflowMeta)Mockito.mock(WorkflowMeta.class);
        this.mockedActionMeta = (ActionMeta)Mockito.mock(ActionMeta.class);
        this.mockedActionStart = (ActionStart)Mockito.mock(ActionStart.class);
        this.mockedLogChannel = (LogChannel)Mockito.mock(LogChannel.class);
    }

    @Test
    public void testTwoWorkflowsGetSameLogChannelId() {
        WorkflowMeta meta = (WorkflowMeta)Mockito.mock(WorkflowMeta.class);
        LocalWorkflowEngine workflow1 = new LocalWorkflowEngine(meta);
        LocalWorkflowEngine workflow2 = new LocalWorkflowEngine(meta);
        Assert.assertEquals((Object)workflow1.getLogChannelId(), (Object)workflow2.getLogChannelId());
    }

    @Test
    public void testExecutionStoppedListenersConcurrentModification() throws InterruptedException {
        CountDownLatch start = new CountDownLatch(1);
        LocalWorkflowEngine workflow = new LocalWorkflowEngine();
        WorkflowStopExecutionCaller stopper = new WorkflowStopExecutionCaller((IWorkflowEngine<WorkflowMeta>)workflow, start);
        WorkflowStoppedListenerAdder adder = new WorkflowStoppedListenerAdder((IWorkflowEngine<WorkflowMeta>)workflow, start);
        this.startThreads(stopper, adder, start);
        Assert.assertEquals((String)"All workflow stop listeners is added", (long)this.count, (long)adder.c);
        Assert.assertEquals((String)"All stop call success", (long)this.count, (long)stopper.c);
    }

    private void startThreads(Runnable run1, Runnable run2, CountDownLatch start) throws InterruptedException {
        Thread thread1 = new Thread(run1);
        Thread thread2 = new Thread(run2);
        thread1.start();
        thread2.start();
        start.countDown();
        thread1.join();
        thread2.join();
    }

    private class WorkflowStopExecutionCaller
    extends WorkflowKicker {
        WorkflowStopExecutionCaller(IWorkflowEngine<WorkflowMeta> workflow, CountDownLatch start) {
            super(workflow, start);
        }

        @Override
        public void run() {
            this.await();
            while (!this.isStopped()) {
                this.workflow.stopExecution();
            }
        }
    }

    private class WorkflowStoppedListenerAdder
    extends WorkflowKicker {
        WorkflowStoppedListenerAdder(IWorkflowEngine<WorkflowMeta> workflow, CountDownLatch start) {
            super(workflow, start);
        }

        @Override
        public void run() {
            this.await();
            while (!this.isStopped()) {
                this.workflow.addExecutionStoppedListener(w -> {});
            }
        }
    }

    private class WorkflowFinishedListenerAdder
    extends WorkflowKicker {
        WorkflowFinishedListenerAdder(IWorkflowEngine<WorkflowMeta> workflow, CountDownLatch start) {
            super(workflow, start);
        }

        @Override
        public void run() {
            this.await();
            while (!this.isStopped()) {
                this.workflow.addExecutionFinishedListener(w -> {});
            }
        }
    }

    private abstract class WorkflowKicker
    implements Runnable {
        protected IWorkflowEngine<WorkflowMeta> workflow;
        protected int c = 0;
        protected CountDownLatch start;
        protected int max;

        WorkflowKicker(IWorkflowEngine<WorkflowMeta> workflow, CountDownLatch start) {
            this.max = WorkflowTest.this.count;
            this.workflow = workflow;
            this.start = start;
        }

        public void await() {
            try {
                this.start.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException();
            }
        }

        public boolean isStopped() {
            ++this.c;
            return this.c >= this.max;
        }
    }
}

