/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.action;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.serializer.memory.MemoryMetadataProvider;
import org.apache.hop.metadata.serializer.xml.XmlMetadataUtil;
import org.apache.hop.workflow.action.IAction;
import org.junit.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ActionSerializationTestUtil {
    public static final <T extends IAction> T testSerialization(String filename, Class<T> clazz) throws Exception {
        return ActionSerializationTestUtil.testSerialization(filename, clazz, "action", (IHopMetadataProvider)new MemoryMetadataProvider());
    }

    public static final <T extends IAction> T testSerialization(String filename, Class<T> clazz, IHopMetadataProvider metadataProvider) throws Exception {
        return ActionSerializationTestUtil.testSerialization(filename, clazz, "action", metadataProvider);
    }

    public static final <T extends IAction> T testSerialization(String filename, Class<T> clazz, String xmlTag, IHopMetadataProvider metadataProvider) throws Exception {
        Document document = XmlHandler.loadXmlFile((InputStream)clazz.getResourceAsStream(filename));
        Node node = XmlHandler.getSubNode((Node)document, (String)xmlTag);
        IAction meta = (IAction)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        XmlMetadataUtil.deSerializeFromXml(null, (Node)node, clazz, (Object)meta, (IHopMetadataProvider)metadataProvider);
        String xml = ActionSerializationTestUtil.getXml(meta);
        ActionSerializationTestUtil.testXmlStringSerialization(clazz, xmlTag, metadataProvider, xml, meta);
        return (T)meta;
    }

    public static <T extends IAction> void testXmlStringSerialization(Class<T> clazz, String xmlTag, IHopMetadataProvider metadataProvider, String xml, T meta) throws HopXmlException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Document copyDocument = XmlHandler.loadXmlString((String)xml);
        Node copyNode = XmlHandler.getSubNode((Node)copyDocument, (String)xmlTag);
        IAction copy = (IAction)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        XmlMetadataUtil.deSerializeFromXml(null, (Node)copyNode, clazz, (Object)copy, (IHopMetadataProvider)metadataProvider);
        Assert.assertEquals((Object)meta.getXml(), (Object)copy.getXml());
    }

    public static String getXml(IAction action) {
        return XmlHandler.openTag((String)"action") + action.getXml() + XmlHandler.closeTag((String)"action");
    }
}

