/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.action;

import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.actions.start.ActionStart;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class WorkflowActionMetaTest {
    private static final String ATTRIBUTE_GROUP = "aGroupName";
    private static final String ATTRIBUTE_KEY = "someKey";
    private static final String ATTRIBUTE_VALUE = "aValue";
    private ActionMeta originActionMeta;
    private ActionMeta copyActionMeta;
    private IAction originAction;

    @Before
    public void setUp() throws Exception {
        this.originActionMeta = new ActionMeta();
        this.copyActionMeta = new ActionMeta();
        this.originAction = new ActionStart("EntrySpecial");
        this.originAction.setChanged(false);
        this.originActionMeta.setAction(this.originAction);
        this.originActionMeta.setAttribute(ATTRIBUTE_GROUP, ATTRIBUTE_KEY, ATTRIBUTE_VALUE);
    }

    @Test
    public void testReplaceMetaCloneEntryOfOrigin() throws Exception {
        this.copyActionMeta.replaceMeta(this.originActionMeta);
        Assert.assertNotSame((String)"Entry of origin and copy Action should be different objects: ", (Object)this.copyActionMeta.getAction(), (Object)this.originActionMeta.getAction());
    }

    @Test
    public void testReplaceMetaDoesNotChangeEntryOfOrigin() throws Exception {
        this.copyActionMeta.replaceMeta(this.originActionMeta);
        Assert.assertEquals((String)"hasChanged in Entry of origin Action should not be changed. ", (Object)false, (Object)this.originActionMeta.getAction().hasChanged());
    }

    @Test
    public void testReplaceMetaChangesEntryOfCopy() throws Exception {
        this.copyActionMeta.replaceMeta(this.originActionMeta);
        Assert.assertEquals((String)"hasChanged in Entry of copy Action should be changed. ", (Object)true, (Object)this.copyActionMeta.getAction().hasChanged());
    }

    @Test
    public void testSetParentMeta() throws Exception {
        WorkflowMeta meta = (WorkflowMeta)Mockito.mock(WorkflowMeta.class);
        this.originActionMeta.setParentWorkflowMeta(meta);
        Assert.assertEquals((Object)meta, (Object)this.originAction.getParentWorkflowMeta());
    }

    @Test
    public void testCloneClonesAttributesMap() throws Exception {
        ActionMeta clonedActionMeta = this.originActionMeta.clone();
        Assert.assertNotNull((Object)clonedActionMeta.getAttributesMap());
        Assert.assertEquals((Object)this.originActionMeta.getAttribute(ATTRIBUTE_GROUP, ATTRIBUTE_KEY), (Object)clonedActionMeta.getAttribute(ATTRIBUTE_GROUP, ATTRIBUTE_KEY));
    }

    @Test
    public void testDeepCloneClonesAttributesMap() throws Exception {
        ActionMeta deepClonedActionMeta = (ActionMeta)this.originActionMeta.cloneDeep();
        Assert.assertNotNull((Object)deepClonedActionMeta.getAttributesMap());
        Assert.assertEquals((Object)this.originActionMeta.getAttribute(ATTRIBUTE_GROUP, ATTRIBUTE_KEY), (Object)deepClonedActionMeta.getAttribute(ATTRIBUTE_GROUP, ATTRIBUTE_KEY));
    }
}

