/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.action.loadsave;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hop.core.HopEnvironment;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.pipeline.transforms.loadsave.validator.IFieldLoadSaveValidator;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.loadsave.LoadSaveTester;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public abstract class WorkflowActionLoadSaveTestSupport<T extends IAction> {
    protected LoadSaveTester<T> tester;

    @BeforeClass
    public static void setUpBeforeClass() throws HopException {
        HopEnvironment.init();
    }

    @Before
    public void setUp() throws Exception {
        List<String> attributes = this.listAttributes();
        Map<String, String> getters = this.createGettersMap();
        Map<String, String> setters = this.createSettersMap();
        Map<String, IFieldLoadSaveValidator<?>> attributeValidators = this.createAttributeValidatorsMap();
        Map<String, IFieldLoadSaveValidator<?>> typeValidators = this.createTypeValidatorsMap();
        this.tester = new LoadSaveTester<T>(this.getActionClass(), attributes, getters, setters, attributeValidators, typeValidators);
    }

    @Test
    public void testSerialization() throws HopException {
        this.tester.testSerialization();
    }

    protected abstract Class<T> getActionClass();

    protected List<String> listAttributes() {
        return Collections.emptyList();
    }

    protected Map<String, String> createGettersMap() {
        return Collections.emptyMap();
    }

    protected Map<String, String> createSettersMap() {
        return Collections.emptyMap();
    }

    protected Map<String, IFieldLoadSaveValidator<?>> createAttributeValidatorsMap() {
        return Collections.emptyMap();
    }

    protected Map<String, IFieldLoadSaveValidator<?>> createTypeValidatorsMap() {
        return Collections.emptyMap();
    }

    protected static <T1, T2> Map<T1, T2> toMap(Object ... pairs) {
        HashMap<Object, Object> result = new HashMap<Object, Object>(pairs.length);
        for (int i = 0; i < pairs.length; i += 2) {
            Object key = pairs[i];
            Object value = pairs[i + 1];
            result.put(key, value);
        }
        return result;
    }
}

