/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.www.BaseHopServerPlugin;
import org.apache.hop.www.IHopServerRequestHandler;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class BaseHopServerPluginTest {
    HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
    HttpServletResponse resp = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
    ILogChannel log = (ILogChannel)Mockito.mock(ILogChannel.class);
    IHopServerRequestHandler.IWriterResponse writerResponse = (IHopServerRequestHandler.IWriterResponse)Mockito.mock(IHopServerRequestHandler.IWriterResponse.class);
    IHopServerRequestHandler.IOutputStreamResponse outputStreamResponse = (IHopServerRequestHandler.IOutputStreamResponse)Mockito.mock(IHopServerRequestHandler.IOutputStreamResponse.class);
    PrintWriter printWriter = (PrintWriter)Mockito.mock(PrintWriter.class);
    ServletOutputStream outputStream = (ServletOutputStream)Mockito.mock(ServletOutputStream.class);
    ArgumentCaptor<IHopServerRequestHandler.IHopServerRequest> carteReqCaptor = ArgumentCaptor.forClass(IHopServerRequestHandler.IHopServerRequest.class);
    BaseHopServerPlugin baseHopServerPlugin;

    @Before
    public void before() {
        this.baseHopServerPlugin = (BaseHopServerPlugin)Mockito.spy((Object)new BaseHopServerPlugin(){

            public void handleRequest(IHopServerRequestHandler.IHopServerRequest request) throws IOException {
            }

            public String getContextPath() {
                return null;
            }
        });
        this.baseHopServerPlugin.log = this.log;
    }

    @Test
    public void testDoGet() throws Exception {
        this.baseHopServerPlugin.doGet(this.req, this.resp);
        ((BaseHopServerPlugin)Mockito.verify((Object)this.baseHopServerPlugin)).service(this.req, this.resp);
    }

    @Test
    public void testService() throws Exception {
        Mockito.when((Object)this.req.getContextPath()).thenReturn((Object)"/Path");
        Mockito.when((Object)this.baseHopServerPlugin.getContextPath()).thenReturn((Object)"/Path");
        Mockito.when((Object)this.log.isDebug()).thenReturn((Object)true);
        this.baseHopServerPlugin.service(this.req, this.resp);
        ((ILogChannel)Mockito.verify((Object)this.log)).logDebug(this.baseHopServerPlugin.getService());
        ((BaseHopServerPlugin)Mockito.verify((Object)this.baseHopServerPlugin)).handleRequest((IHopServerRequestHandler.IHopServerRequest)this.carteReqCaptor.capture());
        IHopServerRequestHandler.IHopServerRequest carteRequest = (IHopServerRequestHandler.IHopServerRequest)this.carteReqCaptor.getValue();
        this.testHopServerRequest(carteRequest);
        this.testHopServerResponse(carteRequest.respond(200));
    }

    private void testHopServerResponse(IHopServerRequestHandler.IHopServerResponse response) throws IOException {
        Mockito.when((Object)this.resp.getWriter()).thenReturn((Object)this.printWriter);
        Mockito.when((Object)this.resp.getOutputStream()).thenReturn((Object)this.outputStream);
        response.with("text/xml", this.writerResponse);
        ((HttpServletResponse)Mockito.verify((Object)this.resp)).setContentType("text/xml");
        ((IHopServerRequestHandler.IWriterResponse)Mockito.verify((Object)this.writerResponse)).write(this.printWriter);
        response.with("text/sgml", this.outputStreamResponse);
        ((HttpServletResponse)Mockito.verify((Object)this.resp)).setContentType("text/sgml");
        ((IHopServerRequestHandler.IOutputStreamResponse)Mockito.verify((Object)this.outputStreamResponse)).write((OutputStream)this.outputStream);
        response.withMessage("Message");
        ((HttpServletResponse)Mockito.verify((Object)this.resp)).setContentType("text/plain");
        ((PrintWriter)Mockito.verify((Object)this.printWriter)).println("Message");
    }

    private void testHopServerRequest(IHopServerRequestHandler.IHopServerRequest carteRequest) {
        Mockito.when((Object)this.req.getMethod()).thenReturn((Object)"POST");
        Mockito.when((Object)this.req.getHeader("Connection")).thenReturn((Object)"Keep-Alive");
        Mockito.when((Object)this.req.getParameter("param1")).thenReturn((Object)"val1");
        Mockito.when((Object)this.req.getParameterNames()).thenReturn(Collections.enumeration(Arrays.asList("name1", "name2")));
        Mockito.when((Object)this.req.getParameterValues((String)Matchers.any(String.class))).thenReturn((Object)new String[]{"val"});
        Mockito.when((Object)this.req.getHeaderNames()).thenReturn(Collections.enumeration(Arrays.asList("name1", "name2")));
        Mockito.when((Object)this.req.getHeaders("name1")).thenReturn(Collections.enumeration(ImmutableList.of((Object)"val")));
        Mockito.when((Object)this.req.getHeaders("name2")).thenReturn(Collections.enumeration(ImmutableList.of((Object)"val")));
        Assert.assertThat((Object)carteRequest.getMethod(), (Matcher)CoreMatchers.is((Object)"POST"));
        Assert.assertThat((Object)carteRequest.getHeader("Connection"), (Matcher)CoreMatchers.is((Object)"Keep-Alive"));
        Assert.assertThat((Object)carteRequest.getParameter("param1"), (Matcher)CoreMatchers.is((Object)"val1"));
        this.checkMappedVals(carteRequest.getParameters());
        this.checkMappedVals(carteRequest.getHeaders());
    }

    private void checkMappedVals(Map<String, Collection<String>> map) {
        Assert.assertThat((Object)map.size(), (Matcher)CoreMatchers.is((Object)2));
        Collection<String> name1Params = map.get("name1");
        Collection<String> name2Params = map.get("name2");
        Assert.assertThat((Object)name1Params.contains("val"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)name2Params.contains("val"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)(name1Params.size() == 1 && name2Params.size() == 1 ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testGetService() throws Exception {
        Mockito.when((Object)this.baseHopServerPlugin.getContextPath()).thenReturn((Object)"/Path");
        Assert.assertThat((Object)this.baseHopServerPlugin.getService().startsWith("/Path"), (Matcher)CoreMatchers.is((Object)true));
    }
}

