/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.www.GetStatusServlet;
import org.apache.hop.www.HopServerObjectEntry;
import org.apache.hop.www.PipelineMap;
import org.apache.hop.www.ServletTestUtils;
import org.apache.hop.www.WorkflowMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class GetStatusServletTest {
    private PipelineMap mockPipelineMap;
    private WorkflowMap mockWorkflowMap;
    private GetStatusServlet getStatusServlet;

    @Before
    public void setup() {
        this.mockPipelineMap = (PipelineMap)Mockito.mock(PipelineMap.class);
        this.mockWorkflowMap = (WorkflowMap)Mockito.mock(WorkflowMap.class);
        this.getStatusServlet = new GetStatusServlet(this.mockPipelineMap, this.mockWorkflowMap);
    }

    @Test
    public void testGetStatusServletEscapesHtmlWhenPipelineNotFound() throws ServletException, IOException {
        HttpServletRequest mockHttpServletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse mockHttpServletResponse = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        StringWriter out = new StringWriter();
        PrintWriter printWriter = new PrintWriter(out);
        Mockito.when((Object)mockHttpServletRequest.getContextPath()).thenReturn((Object)"/hop/status");
        Mockito.when((Object)mockHttpServletRequest.getParameter(Matchers.anyString())).thenReturn((Object)"!@#$%\"'^&*()<>&/test string&");
        Mockito.when((Object)mockHttpServletResponse.getWriter()).thenReturn((Object)printWriter);
        this.getStatusServlet.doGet(mockHttpServletRequest, mockHttpServletResponse);
        Assert.assertFalse((boolean)ServletTestUtils.hasBadText(ServletTestUtils.getInsideOfTag("TITLE", out.toString())));
    }

    @Test
    public void testGetStatusServletEscapesHtmlWhenPipelineFound() throws ServletException, IOException {
        HopLogStore.init();
        HttpServletRequest mockHttpServletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse mockHttpServletResponse = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Pipeline mockPipeline = (Pipeline)Mockito.mock(Pipeline.class);
        PipelineMeta mockPipelineMeta = (PipelineMeta)Mockito.mock(PipelineMeta.class);
        ILogChannel mockChannelInterface = (ILogChannel)Mockito.mock(ILogChannel.class);
        StringWriter out = new StringWriter();
        PrintWriter printWriter = new PrintWriter(out);
        Mockito.when((Object)mockHttpServletRequest.getContextPath()).thenReturn((Object)"/hop/status");
        Mockito.when((Object)mockHttpServletRequest.getParameter(Matchers.anyString())).thenReturn((Object)"!@#$%\"'^&*()<>&/test string&");
        Mockito.when((Object)mockHttpServletResponse.getWriter()).thenReturn((Object)printWriter);
        Mockito.when((Object)this.mockPipelineMap.getPipeline((HopServerObjectEntry)Matchers.any(HopServerObjectEntry.class))).thenReturn((Object)mockPipeline);
        Mockito.when((Object)mockPipeline.getLogChannel()).thenReturn((Object)mockChannelInterface);
        Mockito.when((Object)mockPipeline.getPipelineMeta()).thenReturn((Object)mockPipelineMeta);
        Mockito.when((Object)mockPipelineMeta.getMaximum()).thenReturn((Object)new Point(10, 10));
        this.getStatusServlet.doGet(mockHttpServletRequest, mockHttpServletResponse);
        Assert.assertFalse((boolean)out.toString().contains("!@#$%\"'^&*()<>&/test string&"));
    }
}

