/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.hop.core.Result;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.junit.rules.RestoreHopEngineEnvironment;
import org.apache.hop.www.HopServerPipelineStatus;
import org.apache.hop.www.HopServerPipelineStatusLoadSaveTester;
import org.apache.hop.www.HopServerWorkflowStatusTest;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.w3c.dom.Node;

public class HopServerPipelineStatusTest {
    @ClassRule
    public static RestoreHopEngineEnvironment env = new RestoreHopEngineEnvironment();

    @Test
    public void testStaticFinal() {
        Assert.assertEquals((Object)"pipeline-status", (Object)"pipeline-status");
    }

    @Test
    public void testNoDate() throws HopException {
        String pipelineName = "testNullDate";
        String id = UUID.randomUUID().toString();
        String status = "Finished";
        HopServerPipelineStatus ts = new HopServerPipelineStatus(pipelineName, id, status);
        String resultXML = ts.getXml();
        Node newPipelineStatus = XmlHandler.getSubNode((Node)XmlHandler.loadXmlString((String)resultXML), (String)"pipeline-status");
        Assert.assertEquals((String)"The XML document should match after rebuilding from XML", (Object)resultXML, (Object)HopServerPipelineStatus.fromXml((String)resultXML).getXml());
        Assert.assertEquals((String)"There should be one \"log_date\" node in the XML", (long)1L, (long)XmlHandler.countNodes((Node)newPipelineStatus, (String)"log_date"));
        Assert.assertTrue((String)"The \"log_date\" node should have a null value", (!Utils.isEmpty((CharSequence)XmlHandler.getTagValue((Node)newPipelineStatus, (String)"log_date")) ? 1 : 0) != 0);
    }

    @Test
    public void testWithDate() throws HopException {
        String pipelineName = "testWithDate";
        String id = UUID.randomUUID().toString();
        String status = "Finished";
        Date logDate = new Date();
        HopServerPipelineStatus ts = new HopServerPipelineStatus(pipelineName, id, status);
        ts.setLogDate(logDate);
        String resultXML = ts.getXml();
        Node newPipelineStatus = XmlHandler.getSubNode((Node)XmlHandler.loadXmlString((String)resultXML), (String)"pipeline-status");
        Assert.assertEquals((String)"The XML document should match after rebuilding from XML", (Object)resultXML, (Object)HopServerPipelineStatus.fromXml((String)resultXML).getXml());
        Assert.assertEquals((String)"There should be one \"log_date\" node in the XML", (long)1L, (long)XmlHandler.countNodes((Node)newPipelineStatus, (String)"log_date"));
        Assert.assertEquals((String)"The \"log_date\" node should match the original value", (Object)XmlHandler.date2string((Date)logDate), (Object)XmlHandler.getTagValue((Node)newPipelineStatus, (String)"log_date"));
    }

    @Test
    public void testSerialization() throws HopException {
        List<String> attributes = Arrays.asList("PipelineName", "Id", "StatusDescription", "ErrorDescription", "LogDate", "Paused", "FirstLoggingLineNr", "LastLoggingLineNr", "LoggingString");
        HashMap attributeMap = new HashMap();
        attributeMap.put("LoggingString", new HopServerWorkflowStatusTest.LoggingStringLoadSaveValidator());
        HopServerPipelineStatusLoadSaveTester tester = new HopServerPipelineStatusLoadSaveTester(HopServerPipelineStatus.class, attributes, attributeMap);
        tester.testSerialization();
    }

    @Test
    public void testGetXML() throws HopException {
        HopServerPipelineStatus pipelineStatus = new HopServerPipelineStatus();
        RowMetaAndData rowMetaAndData = new RowMetaAndData();
        String testData = "testData";
        rowMetaAndData.addValue((IValueMeta)new ValueMetaString(), (Object)testData);
        ArrayList<RowMetaAndData> rows = new ArrayList<RowMetaAndData>();
        rows.add(rowMetaAndData);
        Result result = new Result();
        result.setRows(rows);
        pipelineStatus.setResult(result);
        Assert.assertFalse((boolean)pipelineStatus.getXml().contains(testData));
        Assert.assertTrue((boolean)pipelineStatus.getXml(true).contains(testData));
    }
}

