/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.hop.core.HopEnvironment;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.junit.rules.RestoreHopEngineEnvironment;
import org.apache.hop.pipeline.transforms.loadsave.validator.IFieldLoadSaveValidator;
import org.apache.hop.server.HttpUtil;
import org.apache.hop.www.HopServerWorkflowStatus;
import org.apache.hop.www.HopServerWorkflowStatusLoadSaveTester;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.w3c.dom.Node;

public class HopServerWorkflowStatusTest {
    @ClassRule
    public static RestoreHopEngineEnvironment env = new RestoreHopEngineEnvironment();

    @BeforeClass
    public static void setUpBeforeClass() throws HopException {
        HopEnvironment.init();
    }

    @Test
    public void testStaticFinal() {
        Assert.assertEquals((Object)"workflow-status", (Object)"workflow-status");
    }

    @Test
    public void testNoDate() throws HopException {
        String workflowName = "testNullDate";
        String id = UUID.randomUUID().toString();
        String status = "Finished";
        HopServerWorkflowStatus js = new HopServerWorkflowStatus(workflowName, id, status);
        String resultXML = js.getXml();
        Node newJobStatus = XmlHandler.getSubNode((Node)XmlHandler.loadXmlString((String)resultXML), (String)"workflow-status");
        Assert.assertEquals((String)"The XML document should match after rebuilding from XML", (Object)resultXML, (Object)HopServerWorkflowStatus.fromXml((String)resultXML).getXml());
        Assert.assertEquals((String)"There should be one \"log_date\" node in the XML", (long)1L, (long)XmlHandler.countNodes((Node)newJobStatus, (String)"log_date"));
        Assert.assertTrue((String)"The \"log_date\" node should have a null value", (!Utils.isEmpty((CharSequence)XmlHandler.getTagValue((Node)newJobStatus, (String)"log_date")) ? 1 : 0) != 0);
    }

    @Test
    public void testWithDate() throws HopException {
        String workflowName = "testWithDate";
        String id = UUID.randomUUID().toString();
        String status = "Finished";
        Date logDate = new Date();
        HopServerWorkflowStatus js = new HopServerWorkflowStatus(workflowName, id, status);
        js.setLogDate(logDate);
        String resultXML = js.getXml();
        Node newJobStatus = XmlHandler.getSubNode((Node)XmlHandler.loadXmlString((String)resultXML), (String)"workflow-status");
        Assert.assertEquals((String)"The XML document should match after rebuilding from XML", (Object)resultXML, (Object)HopServerWorkflowStatus.fromXml((String)resultXML).getXml());
        Assert.assertEquals((String)"There should be one \"log_date\" node in the XML", (long)1L, (long)XmlHandler.countNodes((Node)newJobStatus, (String)"log_date"));
        Assert.assertEquals((String)"The \"log_date\" node should match the original value", (Object)XmlHandler.date2string((Date)logDate), (Object)XmlHandler.getTagValue((Node)newJobStatus, (String)"log_date"));
    }

    @Test
    public void testSerialization() throws HopException {
        List<String> attributes = Arrays.asList("WorkflowName", "Id", "StatusDescription", "ErrorDescription", "LogDate", "LoggingString", "FirstLoggingLineNr", "LastLoggingLineNr");
        HashMap attributeMap = new HashMap();
        attributeMap.put("LoggingString", new LoggingStringLoadSaveValidator());
        HopServerWorkflowStatusLoadSaveTester tester = new HopServerWorkflowStatusLoadSaveTester(HopServerWorkflowStatus.class, attributes, attributeMap);
        tester.testSerialization();
    }

    public static class LoggingStringLoadSaveValidator
    implements IFieldLoadSaveValidator<String> {
        @Override
        public String getTestObject() {
            try {
                return HttpUtil.encodeBase64ZippedString((String)UUID.randomUUID().toString());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean validateTestObject(String testObject, Object actual) {
            try {
                return HttpUtil.decodeBase64ZippedString((String)testObject).equals(actual);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

