/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.Assert;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineConfiguration;
import org.apache.hop.pipeline.PipelineExecutionConfiguration;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.www.HopServerObjectEntry;
import org.apache.hop.www.PipelineMap;
import org.apache.hop.www.PrepareExecutionPipelineServlet;
import org.apache.hop.www.ServletTestUtils;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.owasp.encoder.Encode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
public class PrepareExecutionPipelineServletTest {
    private PipelineMap mockPipelineMap;
    private PrepareExecutionPipelineServlet prepareExecutionPipelineServlet;

    @Before
    public void setup() {
        this.mockPipelineMap = (PipelineMap)Mockito.mock(PipelineMap.class);
        this.prepareExecutionPipelineServlet = new PrepareExecutionPipelineServlet(this.mockPipelineMap);
    }

    @Test
    @PrepareForTest(value={Encode.class})
    public void testPausePipelineServletEscapesHtmlWhenPipelineNotFound() throws ServletException, IOException {
        HttpServletRequest mockHttpServletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse mockHttpServletResponse = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        StringWriter out = new StringWriter();
        PrintWriter printWriter = new PrintWriter(out);
        PowerMockito.spy(Encode.class);
        Mockito.when((Object)mockHttpServletRequest.getContextPath()).thenReturn((Object)"/hop/prepareExec");
        Mockito.when((Object)mockHttpServletRequest.getParameter(Matchers.anyString())).thenReturn((Object)"!@#$%\"'^&*()<>&/test string&");
        Mockito.when((Object)mockHttpServletResponse.getWriter()).thenReturn((Object)printWriter);
        this.prepareExecutionPipelineServlet.doGet(mockHttpServletRequest, mockHttpServletResponse);
        Assert.assertFalse((boolean)ServletTestUtils.hasBadText(ServletTestUtils.getInsideOfTag("H1", out.toString())));
        PowerMockito.verifyStatic(Encode.class);
        Encode.forHtml((String)Matchers.anyString());
    }

    @Test
    @PrepareForTest(value={Encode.class})
    public void testPausePipelineServletEscapesHtmlWhenPipelineFound() throws ServletException, IOException {
        HopLogStore.init();
        HttpServletRequest mockHttpServletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse mockHttpServletResponse = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Pipeline mockPipeline = (Pipeline)Mockito.mock(Pipeline.class);
        PipelineConfiguration mockPipelineConf = (PipelineConfiguration)Mockito.mock(PipelineConfiguration.class);
        PipelineMeta mockPipelineMeta = (PipelineMeta)Mockito.mock(PipelineMeta.class);
        PipelineExecutionConfiguration mockPipelineExecutionConf = (PipelineExecutionConfiguration)Mockito.mock(PipelineExecutionConfiguration.class);
        ILogChannel mockChannelInterface = (ILogChannel)Mockito.mock(ILogChannel.class);
        StringWriter out = new StringWriter();
        PrintWriter printWriter = new PrintWriter(out);
        PowerMockito.spy(Encode.class);
        Mockito.when((Object)mockHttpServletRequest.getContextPath()).thenReturn((Object)"/hop/prepareExec");
        Mockito.when((Object)mockHttpServletRequest.getParameter(Matchers.anyString())).thenReturn((Object)"!@#$%\"'^&*()<>&/test string&");
        Mockito.when((Object)mockHttpServletResponse.getWriter()).thenReturn((Object)printWriter);
        Mockito.when((Object)this.mockPipelineMap.getPipeline((HopServerObjectEntry)Matchers.any(HopServerObjectEntry.class))).thenReturn((Object)mockPipeline);
        Mockito.when((Object)this.mockPipelineMap.getConfiguration((HopServerObjectEntry)Matchers.any(HopServerObjectEntry.class))).thenReturn((Object)mockPipelineConf);
        Mockito.when((Object)mockPipelineConf.getPipelineExecutionConfiguration()).thenReturn((Object)mockPipelineExecutionConf);
        Mockito.when((Object)mockPipeline.getLogChannel()).thenReturn((Object)mockChannelInterface);
        Mockito.when((Object)mockPipeline.getPipelineMeta()).thenReturn((Object)mockPipelineMeta);
        Mockito.when((Object)mockPipelineMeta.getMaximum()).thenReturn((Object)new Point(10, 10));
        this.prepareExecutionPipelineServlet.doGet(mockHttpServletRequest, mockHttpServletResponse);
        Assert.assertFalse((boolean)ServletTestUtils.hasBadText(ServletTestUtils.getInsideOfTag("H1", out.toString())));
        PowerMockito.verifyStatic(Encode.class);
        Encode.forHtml((String)Matchers.anyString());
    }
}

