/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.Assert;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.workflow.Workflow;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.apache.hop.www.HopServerObjectEntry;
import org.apache.hop.www.ServletTestUtils;
import org.apache.hop.www.StartWorkflowServlet;
import org.apache.hop.www.WorkflowMap;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.owasp.encoder.Encode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
public class StartWorkflowServletTest {
    private WorkflowMap mockWorkflowMap;
    private StartWorkflowServlet startJobServlet;

    @Before
    public void setup() {
        this.mockWorkflowMap = (WorkflowMap)Mockito.mock(WorkflowMap.class);
        this.startJobServlet = new StartWorkflowServlet(this.mockWorkflowMap);
    }

    @Test
    @PrepareForTest(value={Encode.class})
    public void testStartWorkflowServletEscapesHtmlWhenPipelineNotFound() throws ServletException, IOException {
        HttpServletRequest mockHttpServletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse mockHttpServletResponse = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        StringWriter out = new StringWriter();
        PrintWriter printWriter = new PrintWriter(out);
        PowerMockito.spy(Encode.class);
        Mockito.when((Object)mockHttpServletRequest.getContextPath()).thenReturn((Object)"/hop/startWorkflow");
        Mockito.when((Object)mockHttpServletRequest.getParameter(Matchers.anyString())).thenReturn((Object)"!@#$%\"'^&*()<>&/test string&");
        Mockito.when((Object)mockHttpServletResponse.getWriter()).thenReturn((Object)printWriter);
        this.startJobServlet.doGet(mockHttpServletRequest, mockHttpServletResponse);
        Assert.assertFalse((boolean)ServletTestUtils.hasBadText(ServletTestUtils.getInsideOfTag("H1", out.toString())));
        PowerMockito.verifyStatic(Encode.class);
        Encode.forHtml((String)Matchers.anyString());
    }

    @Test
    @PrepareForTest(value={Encode.class})
    public void testStartWorkflowServletEscapesHtmlWhenPipelineFound() throws ServletException, IOException {
        HopLogStore.init();
        HttpServletRequest mockHttpServletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse mockHttpServletResponse = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        IWorkflowEngine mockWorkflow = (IWorkflowEngine)Mockito.mock(Workflow.class);
        WorkflowMeta mockWorkflowMeta = (WorkflowMeta)Mockito.mock(WorkflowMeta.class);
        ILogChannel mockLogChannelInterface = (ILogChannel)Mockito.mock(ILogChannel.class);
        mockWorkflowMeta.setName("!@#$%\"'^&*()<>&/test string&");
        StringWriter out = new StringWriter();
        PrintWriter printWriter = new PrintWriter(out);
        PowerMockito.spy(Encode.class);
        Mockito.when((Object)mockHttpServletRequest.getContextPath()).thenReturn((Object)"/hop/startWorkflow");
        Mockito.when((Object)mockHttpServletRequest.getParameter(Matchers.anyString())).thenReturn((Object)"!@#$%\"'^&*()<>&/test string&");
        Mockito.when((Object)mockHttpServletResponse.getWriter()).thenReturn((Object)printWriter);
        Mockito.when((Object)this.mockWorkflowMap.getWorkflow((HopServerObjectEntry)Matchers.any(HopServerObjectEntry.class))).thenReturn((Object)mockWorkflow);
        Mockito.when((Object)mockWorkflow.getLogChannelId()).thenReturn((Object)"!@#$%\"'^&*()<>&/test string&");
        Mockito.when((Object)mockWorkflow.getLogChannel()).thenReturn((Object)mockLogChannelInterface);
        Mockito.when((Object)mockWorkflow.getWorkflowMeta()).thenReturn((Object)mockWorkflowMeta);
        Mockito.when((Object)mockWorkflowMeta.getMaximum()).thenReturn((Object)new Point(10, 10));
        this.startJobServlet.doGet(mockHttpServletRequest, mockHttpServletResponse);
        Assert.assertFalse((boolean)ServletTestUtils.hasBadText(ServletTestUtils.getInsideOfTag("H1", out.toString())));
        PowerMockito.verifyStatic(Encode.class);
        Encode.forHtml((String)Matchers.anyString());
    }
}

