/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import java.util.UUID;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.www.WebResult;
import org.junit.Assert;
import org.junit.Test;

public class WebResultTest {
    @Test
    public void testStatics() {
        Assert.assertEquals((Object)"webresult", (Object)"webresult");
        Assert.assertEquals((Object)"OK", (Object)"OK");
        Assert.assertEquals((Object)"ERROR", (Object)"ERROR");
        Assert.assertNotNull((Object)WebResult.OK);
        Assert.assertEquals((Object)"OK", (Object)WebResult.OK.getResult());
        Assert.assertNull((Object)WebResult.OK.getMessage());
        Assert.assertNull((Object)WebResult.OK.getId());
    }

    @Test
    public void testConstructors() {
        String expectedResult = UUID.randomUUID().toString();
        WebResult result = new WebResult(expectedResult);
        Assert.assertEquals((Object)expectedResult, (Object)result.getResult());
        String expectedMessage = UUID.randomUUID().toString();
        result = new WebResult(expectedResult, expectedMessage);
        Assert.assertEquals((Object)expectedResult, (Object)result.getResult());
        Assert.assertEquals((Object)expectedMessage, (Object)result.getMessage());
        String expectedId = UUID.randomUUID().toString();
        result = new WebResult(expectedResult, expectedMessage, expectedId);
        Assert.assertEquals((Object)expectedResult, (Object)result.getResult());
        Assert.assertEquals((Object)expectedMessage, (Object)result.getMessage());
        Assert.assertEquals((Object)expectedId, (Object)result.getId());
    }

    @Test
    public void testSerialization() throws HopXmlException {
        WebResult original = new WebResult(UUID.randomUUID().toString(), UUID.randomUUID().toString(), UUID.randomUUID().toString());
        String xml = original.getXml();
        WebResult copy = WebResult.fromXmlString((String)xml);
        Assert.assertNotNull((Object)copy);
        Assert.assertNotSame((Object)original, (Object)copy);
        Assert.assertEquals((Object)original.getResult(), (Object)copy.getResult());
        Assert.assertEquals((Object)original.getMessage(), (Object)copy.getMessage());
        Assert.assertEquals((Object)original.getId(), (Object)copy.getId());
    }

    @Test
    public void testSetters() {
        WebResult result = new WebResult("");
        Assert.assertEquals((Object)"", (Object)result.getResult());
        result.setMessage("fakeMessage");
        Assert.assertEquals((Object)"fakeMessage", (Object)result.getMessage());
        result.setResult("fakeResult");
        Assert.assertEquals((Object)"fakeResult", (Object)result.getResult());
        result.setId("fakeId");
        Assert.assertEquals((Object)"fakeId", (Object)result.getId());
    }
}

