/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.junit.rules.RestoreHopEngineEnvironment;
import org.apache.hop.server.HopServer;
import org.apache.hop.www.HopServerConfig;
import org.apache.hop.www.PipelineMap;
import org.apache.hop.www.WebServer;
import org.apache.hop.www.WorkflowMap;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;

@Ignore
public class WebServerTest {
    @ClassRule
    public static RestoreHopEngineEnvironment env = new RestoreHopEngineEnvironment();
    private static final String EMPTY_STRING = "";
    private static final boolean SHOULD_JOIN = false;
    private static final String HOST_NAME = "localhost";
    private static final int PORT = 8099;
    private static final int SHUTDOEN_PORT = 8098;
    private static final String ACCEPTORS = "5";
    private static final int EXPECTED_ACCEPTORS = 5;
    private static final String ACCEPT_QUEUE_SIZE = "5000";
    private static final int EXPECTED_ACCEPT_QUEUE_SIZE = 5000;
    private static final String RES_MAX_IDLE_TIME = "200";
    private static final int EXPECTED_RES_MAX_IDLE_TIME = 200;
    private static final int EXPECTED_CONNECTORS_SIZE = 1;
    private WebServer webServer;
    private WebServer webServerNg;
    private PipelineMap trMapMock = (PipelineMap)Mockito.mock(PipelineMap.class);
    private HopServerConfig sServerConfMock = (HopServerConfig)Mockito.mock(HopServerConfig.class);
    private HopServer sServer = (HopServer)Mockito.mock(HopServer.class);
    private WorkflowMap jbMapMock = (WorkflowMap)Mockito.mock(WorkflowMap.class);
    private ILogChannel logMock = (ILogChannel)Mockito.mock(ILogChannel.class);
    private static ServerConnector defServerConnector;

    @Before
    public void setup() throws Exception {
        System.setProperty("HOP_SERVER_JETTY_ACCEPTORS", ACCEPTORS);
        System.setProperty("HOP_SERVER_JETTY_ACCEPT_QUEUE_SIZE", ACCEPT_QUEUE_SIZE);
        System.setProperty("HOP_SERVER_JETTY_RES_MAX_IDLE_TIME", RES_MAX_IDLE_TIME);
        Server server = new Server();
        defServerConnector = new ServerConnector(server);
        Mockito.when((Object)this.sServerConfMock.getHopServer()).thenReturn((Object)this.sServer);
        Mockito.when((Object)this.trMapMock.getHopServerConfig()).thenReturn((Object)this.sServerConfMock);
        Mockito.when((Object)this.sServer.getPassword()).thenReturn((Object)"cluster");
        Mockito.when((Object)this.sServer.getUsername()).thenReturn((Object)"cluster");
        this.webServer = new WebServer(this.logMock, this.trMapMock, this.jbMapMock, HOST_NAME, 8099, 8098, false, null);
    }

    @After
    public void tearDown() {
        this.webServer.setWebServerShutdownHandler(null);
        this.webServer.stopServer();
        System.getProperties().remove("HOP_SERVER_JETTY_ACCEPTORS");
        System.getProperties().remove("HOP_SERVER_JETTY_ACCEPT_QUEUE_SIZE");
        System.getProperties().remove("HOP_SERVER_JETTY_RES_MAX_IDLE_TIME");
    }

    @Test
    public void testJettyOption_AcceptQueueSizeSetUp() throws Exception {
        Assert.assertEquals((long)this.getSocketConnectors(this.webServer).size(), (long)1L);
        for (ServerConnector sc : this.getSocketConnectors(this.webServer)) {
            Assert.assertEquals((long)5000L, (long)sc.getAcceptQueueSize());
        }
    }

    @Test
    public void testJettyOption_LowResourceMaxIdleTimeSetUp() throws Exception {
        Assert.assertEquals((long)this.getSocketConnectors(this.webServer).size(), (long)1L);
        for (ServerConnector sc : this.getSocketConnectors(this.webServer)) {
            Assert.assertEquals((long)200L, (long)sc.getIdleTimeout());
        }
    }

    @Test
    public void testNoExceptionAndUsingDefaultServerValue_WhenJettyOptionSetAsInvalidValue() throws Exception {
        System.setProperty("HOP_SERVER_JETTY_ACCEPTORS", "TEST");
        try {
            this.webServerNg = new WebServer(this.logMock, this.trMapMock, this.jbMapMock, HOST_NAME, 8100, 8098, false, null);
        }
        catch (NumberFormatException nmbfExc) {
            Assert.fail((String)("Should not have thrown any NumberFormatException but it does: " + nmbfExc));
        }
        Assert.assertEquals((long)this.getSocketConnectors(this.webServerNg).size(), (long)1L);
        for (ServerConnector sc : this.getSocketConnectors(this.webServerNg)) {
            Assert.assertEquals((long)sc.getAcceptors(), (long)sc.getAcceptors());
        }
        this.webServerNg.setWebServerShutdownHandler(null);
        this.webServerNg.stopServer();
    }

    @Test
    public void testNoExceptionAndUsingDefaultServerValue_WhenJettyOptionSetAsEmpty() throws Exception {
        System.setProperty("HOP_SERVER_JETTY_ACCEPTORS", EMPTY_STRING);
        try {
            this.webServerNg = new WebServer(this.logMock, this.trMapMock, this.jbMapMock, HOST_NAME, 8100, 8098, false, null);
        }
        catch (NumberFormatException nmbfExc) {
            Assert.fail((String)("Should not have thrown any NumberFormatException but it does: " + nmbfExc));
        }
        Assert.assertEquals((long)this.getSocketConnectors(this.webServerNg).size(), (long)1L);
        for (ServerConnector sc : this.getSocketConnectors(this.webServerNg)) {
            Assert.assertEquals((long)sc.getAcceptors(), (long)sc.getAcceptors());
        }
        this.webServerNg.setWebServerShutdownHandler(null);
        this.webServerNg.stopServer();
    }

    private List<ServerConnector> getSocketConnectors(WebServer wServer) {
        Connector[] connectors;
        ArrayList<ServerConnector> sConnectors = new ArrayList<ServerConnector>();
        for (Connector cn : connectors = wServer.getServer().getConnectors()) {
            if (!(cn instanceof ServerConnector)) continue;
            sConnectors.add((ServerConnector)cn);
        }
        return sConnectors;
    }
}

