/*
 * Decompiled with CFR 0.152.
 */
package org.apache.test.util;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.test.util.IObjectProvider;
import org.apache.test.util.IObjectTester;
import org.apache.test.util.IObjectValidator;
import org.apache.test.util.impl.CollectionObjectProvider;
import org.apache.test.util.impl.DefaultObjectTester;
import org.apache.test.util.impl.DotEqualsValidator;
import org.apache.test.util.impl.EqualsEqualsValidator;

public class ObjectTesterBuilder<T> {
    private Collection<T> objects;
    private IObjectProvider<T> provider;
    private boolean useEqualsEquals = false;
    private IObjectValidator<T> validator;

    public IObjectTester<T> build() {
        IObjectValidator<T> validator;
        IObjectProvider<T> provider = this.provider;
        if (provider == null && this.objects != null) {
            provider = new CollectionObjectProvider<T>(this.objects);
        }
        if ((validator = this.validator) == null) {
            validator = this.useEqualsEquals ? new EqualsEqualsValidator() : new DotEqualsValidator();
        }
        return new DefaultObjectTester<T>(provider, validator);
    }

    public ObjectTesterBuilder<T> setObjects(Collection<T> objects) {
        this.objects = objects;
        return this;
    }

    public ObjectTesterBuilder<T> addObject(T object) {
        if (this.objects == null) {
            this.objects = new ArrayList<T>();
        }
        this.objects.add(object);
        return this;
    }

    public ObjectTesterBuilder<T> setProvider(IObjectProvider<T> provider) {
        this.provider = provider;
        return this;
    }

    public ObjectTesterBuilder<T> setUseEqualsEquals(boolean useDotEquals) {
        this.useEqualsEquals = useDotEquals;
        return this;
    }

    public ObjectTesterBuilder<T> useEqualsEquals() {
        return this.setUseEqualsEquals(true);
    }

    public ObjectTesterBuilder<T> setValidator(IObjectValidator<T> validator) {
        this.validator = validator;
        return this;
    }
}

