/*
 * Decompiled with CFR 0.152.
 */
package org.apache.test.util;

import org.apache.hop.core.HopEnvironment;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.plugins.TransformPluginType;
import org.apache.hop.junit.rules.RestoreHopEngineEnvironment;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.SingleThreadedPipelineExecutor;
import org.apache.hop.pipeline.engines.local.LocalPipelineEngine;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public abstract class SingleThreadedExecutionGuarder<Meta extends ITransformMeta> {
    @ClassRule
    public static RestoreHopEngineEnvironment env = new RestoreHopEngineEnvironment();

    @BeforeClass
    public static void setUp() throws Exception {
        HopEnvironment.init();
    }

    protected abstract Meta createMeta();

    @Test(expected=HopException.class)
    public void failsWhenGivenNonSingleThreadTransforms() throws Exception {
        Meta metaInterface = this.createMeta();
        PluginRegistry plugReg = PluginRegistry.getInstance();
        String id = plugReg.getPluginId(TransformPluginType.class, metaInterface);
        Assert.assertNotNull((String)"pluginId", (Object)id);
        TransformMeta transformMeta = new TransformMeta(id, "transformMetrics", metaInterface);
        PipelineMeta pipelineMeta = new PipelineMeta();
        pipelineMeta.setName("failsWhenGivenNonSingleThreadTransforms");
        pipelineMeta.addTransform(transformMeta);
        LocalPipelineEngine pipeline = new LocalPipelineEngine(pipelineMeta);
        pipeline.prepareExecution();
        SingleThreadedPipelineExecutor executor = new SingleThreadedPipelineExecutor((Pipeline)pipeline);
        executor.init();
    }
}

