/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.database.dialog;

import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.DbCache;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.database.SqlScriptStatement;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.logging.LoggingObjectType;
import org.apache.hop.core.logging.SimpleLoggingObject;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterTextDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.dialog.PreviewRowsDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.StyledTextComp;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class SqlEditor {
    private static final Class<?> PKG = SqlEditor.class;
    public static final ILoggingObject loggingObject = new SimpleLoggingObject("SQL Editor", LoggingObjectType.HOP_GUI, null);
    private final PropsUi props = PropsUi.getInstance();
    private StyledTextComp wScript;
    private Label wlPosition;
    private final String input;
    private final DatabaseMeta connection;
    private Shell shell;
    private final DbCache dbcache;
    private final ILogChannel log;
    private int style = 3312;
    private final Shell parentShell;
    private final IVariables variables;

    public SqlEditor(Shell parent, int style, IVariables variables, DatabaseMeta ci, DbCache dbc, String sql) {
        this.log = new LogChannel((Object)ci);
        this.input = sql;
        this.connection = ci;
        this.dbcache = dbc;
        this.parentShell = parent;
        this.style = style != 0 ? style : this.style;
        this.variables = variables;
    }

    public void open() {
        this.shell = new Shell(this.parentShell, this.style);
        PropsUi.setLook((Widget)this.shell);
        this.shell.setImage(GuiResource.getInstance().getImageDatabase());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"SQLEditor.Title", (String[])new String[0]));
        SqlEditor sqlEditor = this;
        int margin = sqlEditor.props.getMargin();
        Button wExec = new Button((Composite)this.shell, 8);
        wExec.setText(BaseMessages.getString(PKG, (String)"SQLEditor.Button.Execute", (String[])new String[0]));
        wExec.addListener(13, e -> {
            try {
                this.exec();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        Button wClear = new Button((Composite)this.shell, 8);
        wClear.setText(BaseMessages.getString(PKG, (String)"SQLEditor.Button.ClearCache", (String[])new String[0]));
        wClear.setToolTipText(BaseMessages.getString(PKG, (String)"SQLEditor.Button.ClearCache.Tooltip", (String[])new String[0]));
        wClear.addListener(13, e -> this.clearCache());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, new Button[]{wExec, wClear, wCancel}, margin, null);
        Label wlScript = new Label((Composite)this.shell, 0);
        wlScript.setText(BaseMessages.getString(PKG, (String)"SQLEditor.Editor.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlScript);
        FormData fdlScript = new FormData();
        fdlScript.left = new FormAttachment(0, 0);
        fdlScript.top = new FormAttachment(0, 0);
        wlScript.setLayoutData((Object)fdlScript);
        this.wScript = new StyledTextComp(this.variables, (Composite)this.shell, 19202);
        this.wScript.setText("");
        PropsUi.setLook((Widget)this.wScript, 1);
        FormData fdScript = new FormData();
        fdScript.left = new FormAttachment(0, 0);
        fdScript.top = new FormAttachment((Control)wlScript, margin);
        fdScript.right = new FormAttachment(100, -10);
        fdScript.bottom = new FormAttachment((Control)wExec, -2 * margin);
        this.wScript.setLayoutData(fdScript);
        this.wScript.addModifyListener(arg0 -> this.setPosition());
        this.wScript.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                SqlEditor.this.setPosition();
            }

            public void keyReleased(KeyEvent e) {
                SqlEditor.this.setPosition();
            }
        });
        this.wScript.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                SqlEditor.this.setPosition();
            }

            public void focusLost(FocusEvent e) {
                SqlEditor.this.setPosition();
            }
        });
        this.wScript.addMouseListener(new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                SqlEditor.this.setPosition();
            }

            public void mouseDown(MouseEvent e) {
                SqlEditor.this.setPosition();
            }

            public void mouseUp(MouseEvent e) {
                SqlEditor.this.setPosition();
            }
        });
        this.wlPosition = new Label((Composite)this.shell, 0);
        this.wlPosition.setText(BaseMessages.getString(PKG, (String)"SQLEditor.LineNr.Label", (String[])new String[]{"0"}));
        PropsUi.setLook((Widget)this.wlPosition);
        FormData fdlPosition = new FormData();
        fdlPosition.left = new FormAttachment(0, 0);
        fdlPosition.top = new FormAttachment((Control)this.wScript, margin);
        fdlPosition.right = new FormAttachment(100, 0);
        this.wlPosition.setLayoutData((Object)fdlPosition);
        this.getData();
        BaseDialog.defaultShellHandling(this.shell, c -> this.exec(), c -> this.cancel());
    }

    public void setPosition() {
        int lineNumber = this.wScript.getLineNumber();
        int columnNumber = this.wScript.getColumnNumber();
        this.wlPosition.setText(BaseMessages.getString(PKG, (String)"SQLEditor.Position.Label", (String[])new String[]{"" + lineNumber, "" + columnNumber}));
    }

    private void clearCache() {
        MessageBox mb = new MessageBox(this.shell, 452);
        mb.setMessage(BaseMessages.getString(PKG, (String)"SQLEditor.ClearWholeCache.Message", (String[])new String[]{this.connection.getName()}));
        mb.setText(BaseMessages.getString(PKG, (String)"SQLEditor.ClearWholeCache.Title", (String[])new String[0]));
        int answer = mb.open();
        switch (answer) {
            case 128: {
                DbCache.getInstance().clear(this.connection.getName());
                mb = new MessageBox(this.shell, 34);
                mb.setMessage(BaseMessages.getString(PKG, (String)"SQLEditor.ConnectionCacheCleared.Message", (String[])new String[]{this.connection.getName()}));
                mb.setText(BaseMessages.getString(PKG, (String)"SQLEditor.ConnectionCacheCleared.Title", (String[])new String[0]));
                mb.open();
                break;
            }
            case 64: {
                DbCache.getInstance().clear(null);
                mb = new MessageBox(this.shell, 34);
                mb.setMessage(BaseMessages.getString(PKG, (String)"SQLEditor.WholeCacheCleared.Message", (String[])new String[0]));
                mb.setText(BaseMessages.getString(PKG, (String)"SQLEditor.WholeCacheCleared.Title", (String[])new String[0]));
                mb.open();
                break;
            }
            case 256: {
                break;
            }
        }
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void getData() {
        if (this.input != null) {
            this.wScript.setText(this.input);
        }
    }

    private void cancel() {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exec() {
        DatabaseMeta databaseMeta = this.connection;
        if (databaseMeta == null) {
            return;
        }
        StringBuilder message = new StringBuilder();
        Database db = new Database(loggingObject, this.variables, databaseMeta);
        try {
            db.connect();
            String sqlScript = Utils.isEmpty((CharSequence)this.wScript.getSelectionText()) ? this.wScript.getText() : this.wScript.getSelectionText();
            List statements = databaseMeta.getIDatabase().getSqlScriptStatements(sqlScript + Const.CR);
            int nrstats = 0;
            for (SqlScriptStatement sql : statements) {
                if (sql.isQuery()) {
                    this.log.logDetailed("launch SELECT statement: " + Const.CR + sql);
                    ++nrstats;
                    try {
                        List rows = db.getRows(sql.getStatement(), 1000);
                        IRowMeta rowMeta = db.getReturnRowMeta();
                        if (rows.size() > 0) {
                            PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, this.variables, 0, BaseMessages.getString(PKG, (String)"SQLEditor.ResultRows.Title", (String[])new String[]{Integer.toString(nrstats)}), rowMeta, rows);
                            prd.open();
                            continue;
                        }
                        MessageBox mb = new MessageBox(this.shell, 34);
                        mb.setMessage(BaseMessages.getString(PKG, (String)"SQLEditor.NoRows.Message", (Object[])new Object[]{sql}));
                        mb.setText(BaseMessages.getString(PKG, (String)"SQLEditor.NoRows.Title", (String[])new String[0]));
                        mb.open();
                    }
                    catch (HopDatabaseException dbe) {
                        new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SQLEditor.ErrorExecSQL.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SQLEditor.ErrorExecSQL.Message", (Object[])new Object[]{sql}), (Exception)((Object)dbe));
                    }
                    continue;
                }
                this.log.logDetailed("launch DDL statement: " + Const.CR + sql);
                ++nrstats;
                int startLogLine = HopLogStore.getLastBufferLineNr();
                try {
                    this.log.logDetailed("Executing SQL: " + Const.CR + sql);
                    db.execStatement(sql.getStatement());
                    message.append(BaseMessages.getString(PKG, (String)"SQLEditor.Log.SQLExecuted", (Object[])new Object[]{sql}));
                    message.append(Const.CR);
                    if (this.dbcache != null) {
                        this.dbcache.clear(databaseMeta.getName());
                    }
                    sql.setOk(true);
                }
                catch (Exception dbe) {
                    sql.setOk(false);
                    String error = BaseMessages.getString(PKG, (String)"SQLEditor.Log.SQLExecError", (Object[])new Object[]{sql, dbe.toString()});
                    message.append(error).append(Const.CR);
                    ErrorDialog dialog = new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SQLEditor.ErrorExecSQL.Title", (String[])new String[0]), error, dbe, true);
                    if (!dialog.isCancelled()) continue;
                    break;
                }
                finally {
                    int endLogLine = HopLogStore.getLastBufferLineNr();
                    sql.setLoggingText(HopLogStore.getAppender().getLogBufferFromTo(db.getLogChannelId(), true, startLogLine, endLogLine).toString());
                    sql.setComplete(true);
                    this.refreshExecutionResults();
                }
            }
            message.append(BaseMessages.getString(PKG, (String)"SQLEditor.Log.StatsExecuted", (String[])new String[]{Integer.toString(nrstats)}));
            message.append(Const.CR);
        }
        catch (HopDatabaseException dbe) {
            MessageBox mb = new MessageBox(this.shell, 33);
            String error = BaseMessages.getString(PKG, (String)"SQLEditor.Error.CouldNotConnect.Message", (String[])new String[]{this.connection == null ? "" : this.connection.getName(), dbe.getMessage()});
            message.append(error).append(Const.CR);
            mb.setMessage(error);
            mb.setText(BaseMessages.getString(PKG, (String)"SQLEditor.Error.CouldNotConnect.Title", (String[])new String[0]));
            mb.open();
        }
        finally {
            db.disconnect();
            this.refreshExecutionResults();
        }
        EnterTextDialog dialog = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"SQLEditor.Result.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SQLEditor.Result.Message", (String[])new String[0]), message.toString(), true);
        dialog.open();
    }

    protected void refreshExecutionResults() {
        this.wScript.redraw();
    }
}

