/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.i18n;

import java.util.List;
import java.util.Map;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.ui.i18n.BundleFile;
import org.apache.hop.ui.i18n.BundlesStore;
import org.apache.hop.ui.i18n.KeyOccurrence;

public class TranslationsStore {
    private List<String> localeList;
    private String mainLocale;
    private Map<String, Map<String, List<KeyOccurrence>>> sourcePackageOccurrences;
    private final BundlesStore bundleStore;
    private ILogChannel log;

    public TranslationsStore(ILogChannel log, List<String> localeList, String mainLocale, Map<String, Map<String, List<KeyOccurrence>>> sourcePackageOccurrences, BundlesStore bundlesStore) {
        this.log = log;
        this.localeList = localeList;
        this.mainLocale = mainLocale;
        this.sourcePackageOccurrences = sourcePackageOccurrences;
        this.bundleStore = bundlesStore;
    }

    public String lookupKeyValue(String locale, String messagesPackage, String key) {
        return this.bundleStore.lookupTranslation(messagesPackage, locale, key);
    }

    public void removeValue(String locale, String sourceFolder, String messagesPackage, String key) {
        this.bundleStore.removeTranslation(messagesPackage, locale, key);
    }

    public void storeValue(String locale, String sourceFolder, String messagesPackage, String key, String value) {
        this.bundleStore.addTranslation(sourceFolder, messagesPackage, locale, key, value);
    }

    public List<BundleFile> getChangedBundleFiles() {
        return this.bundleStore.getChangedBundleFiles();
    }

    public List<BundleFile> findBundleFiles(String searchLocale, String messagesPackage) {
        return this.bundleStore.getBundleFiles(searchLocale, messagesPackage);
    }

    public BundleFile findMainBundleFile(String messagesPackage) {
        List<BundleFile> bundlesFiles = this.findBundleFiles(this.mainLocale, messagesPackage);
        if (bundlesFiles.isEmpty()) {
            return null;
        }
        return bundlesFiles.get(0);
    }

    public List<String> getLocaleList() {
        return this.localeList;
    }

    public void setLocaleList(List<String> localeList) {
        this.localeList = localeList;
    }

    public String getMainLocale() {
        return this.mainLocale;
    }

    public void setMainLocale(String mainLocale) {
        this.mainLocale = mainLocale;
    }

    public Map<String, Map<String, List<KeyOccurrence>>> getSourcePackageOccurrences() {
        return this.sourcePackageOccurrences;
    }

    public void setSourcePackageOccurrences(Map<String, Map<String, List<KeyOccurrence>>> sourcePackageOccurrences) {
        this.sourcePackageOccurrences = sourcePackageOccurrences;
    }

    public BundlesStore getBundleStore() {
        return this.bundleStore;
    }

    public ILogChannel getLog() {
        return this.log;
    }

    public void setLog(ILogChannel log) {
        this.log = log;
    }
}

