/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http;

import java.util.Objects;
import org.apache.hc.core5.http.Header;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class HeaderMatcher
extends BaseMatcher<Header> {
    private final String headerName;
    private final Object headerValue;

    public HeaderMatcher(String headerName, Object headerValue) {
        this.headerName = headerName;
        this.headerValue = headerValue;
    }

    public boolean matches(Object item) {
        if (item instanceof Header) {
            Header header = (Header)item;
            return this.headerName.equalsIgnoreCase(header.getName()) && Objects.equals(this.headerValue, header.getValue());
        }
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("same header as ").appendValue(this.headerValue).appendText(": ").appendValue(this.headerValue);
    }

    public static Matcher<Header> same(String headerName, Object headerValue) {
        return new HeaderMatcher(headerName, headerValue);
    }
}

