/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.entity.mime;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.InputStreamBody;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HeaderElement;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicHeaderValueParser;
import org.apache.hc.core5.http.message.ParserCursor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestMultipartFormHttpEntity {
    TestMultipartFormHttpEntity() {
    }

    @Test
    void testExplicitContractorParams() {
        HttpEntity entity = MultipartEntityBuilder.create().setLaxMode().setBoundary("whatever").setCharset(StandardCharsets.UTF_8).build();
        Assertions.assertNull((Object)entity.getContentEncoding());
        String contentType = entity.getContentType();
        HeaderElement elem = BasicHeaderValueParser.INSTANCE.parseHeaderElement((CharSequence)contentType, new ParserCursor(0, contentType.length()));
        Assertions.assertEquals((Object)"multipart/mixed", (Object)elem.getName());
        NameValuePair p1 = elem.getParameterByName("boundary");
        Assertions.assertNotNull((Object)p1);
        Assertions.assertEquals((Object)"whatever", (Object)p1.getValue());
        NameValuePair p2 = elem.getParameterByName("charset");
        Assertions.assertNull((Object)p2, (String)"RFC7578 does not mention charset parameter for Content-Type, so no charset should be present for MultipartEntity.getContentType()");
    }

    @Test
    void testImplicitContractorParams() {
        HttpEntity entity = MultipartEntityBuilder.create().build();
        Assertions.assertNull((Object)entity.getContentEncoding());
        String contentType = entity.getContentType();
        HeaderElement elem = BasicHeaderValueParser.INSTANCE.parseHeaderElement((CharSequence)contentType, new ParserCursor(0, contentType.length()));
        Assertions.assertEquals((Object)"multipart/mixed", (Object)elem.getName());
        NameValuePair p1 = elem.getParameterByName("boundary");
        Assertions.assertNotNull((Object)p1);
        String boundary = p1.getValue();
        Assertions.assertNotNull((Object)boundary);
        Assertions.assertTrue((boundary.length() >= 30 ? 1 : 0) != 0);
        Assertions.assertTrue((boundary.length() <= 40 ? 1 : 0) != 0);
        NameValuePair p2 = elem.getParameterByName("charset");
        Assertions.assertNull((Object)p2);
    }

    @Test
    void testRepeatable() throws Exception {
        HttpEntity entity = MultipartEntityBuilder.create().addTextBody("p1", "blah blah", ContentType.DEFAULT_TEXT).addTextBody("p2", "yada yada", ContentType.DEFAULT_TEXT).build();
        Assertions.assertTrue((boolean)entity.isRepeatable());
        Assertions.assertFalse((boolean)entity.isChunked());
        Assertions.assertFalse((boolean)entity.isStreaming());
        long len = entity.getContentLength();
        Assertions.assertEquals((long)len, (long)entity.getContentLength());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        entity.writeTo((OutputStream)out);
        out.close();
        byte[] bytes = out.toByteArray();
        Assertions.assertNotNull((Object)bytes);
        Assertions.assertEquals((long)bytes.length, (long)len);
        Assertions.assertEquals((long)len, (long)entity.getContentLength());
        out = new ByteArrayOutputStream();
        entity.writeTo((OutputStream)out);
        out.close();
        bytes = out.toByteArray();
        Assertions.assertNotNull((Object)bytes);
        Assertions.assertEquals((long)bytes.length, (long)len);
    }

    @Test
    void testNonRepeatable() {
        HttpEntity entity = MultipartEntityBuilder.create().addPart("p1", (ContentBody)new InputStreamBody((InputStream)new ByteArrayInputStream("blah blah".getBytes()), ContentType.DEFAULT_BINARY)).addPart("p2", (ContentBody)new InputStreamBody((InputStream)new ByteArrayInputStream("yada yada".getBytes()), ContentType.DEFAULT_BINARY)).build();
        Assertions.assertFalse((boolean)entity.isRepeatable());
        Assertions.assertTrue((boolean)entity.isChunked());
        Assertions.assertTrue((boolean)entity.isStreaming());
        Assertions.assertEquals((long)-1L, (long)entity.getContentLength());
    }
}

