/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl;

import org.apache.hc.client5.http.impl.ProtocolSwitchStrategy;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.apache.hc.core5.http.ssl.TLS;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TestProtocolSwitchStrategy {
    ProtocolSwitchStrategy switchStrategy;

    TestProtocolSwitchStrategy() {
    }

    @BeforeEach
    void setUp() {
        this.switchStrategy = new ProtocolSwitchStrategy();
    }

    @Test
    void testSwitchToTLS() throws Exception {
        BasicHttpResponse response1 = new BasicHttpResponse(101);
        response1.addHeader("Upgrade", (Object)"TLS");
        Assertions.assertEquals((Object)TLS.V_1_2.getVersion(), (Object)this.switchStrategy.switchProtocol((HttpMessage)response1));
        BasicHttpResponse response2 = new BasicHttpResponse(101);
        response2.addHeader("Upgrade", (Object)"TLS/1.3");
        Assertions.assertEquals((Object)TLS.V_1_3.getVersion(), (Object)this.switchStrategy.switchProtocol((HttpMessage)response2));
    }

    @Test
    void testSwitchToHTTP11AndTLS() throws Exception {
        BasicHttpResponse response1 = new BasicHttpResponse(101);
        response1.addHeader("Upgrade", (Object)"TLS, HTTP/1.1");
        Assertions.assertEquals((Object)TLS.V_1_2.getVersion(), (Object)this.switchStrategy.switchProtocol((HttpMessage)response1));
        BasicHttpResponse response2 = new BasicHttpResponse(101);
        response2.addHeader("Upgrade", (Object)",, HTTP/1.1, TLS, ");
        Assertions.assertEquals((Object)TLS.V_1_2.getVersion(), (Object)this.switchStrategy.switchProtocol((HttpMessage)response2));
        BasicHttpResponse response3 = new BasicHttpResponse(101);
        response3.addHeader("Upgrade", (Object)"HTTP/1.1");
        response3.addHeader("Upgrade", (Object)"TLS/1.2");
        Assertions.assertEquals((Object)TLS.V_1_2.getVersion(), (Object)this.switchStrategy.switchProtocol((HttpMessage)response3));
        BasicHttpResponse response4 = new BasicHttpResponse(101);
        response4.addHeader("Upgrade", (Object)"HTTP/1.1");
        response4.addHeader("Upgrade", (Object)"TLS/1.2, TLS/1.3");
        Assertions.assertEquals((Object)TLS.V_1_3.getVersion(), (Object)this.switchStrategy.switchProtocol((HttpMessage)response4));
    }

    @Test
    void testSwitchInvalid() {
        BasicHttpResponse response1 = new BasicHttpResponse(101);
        response1.addHeader("Upgrade", (Object)"Crap");
        Assertions.assertThrows(ProtocolException.class, () -> this.lambda$testSwitchInvalid$0((HttpResponse)response1));
        BasicHttpResponse response2 = new BasicHttpResponse(101);
        response2.addHeader("Upgrade", (Object)"TLS, huh?");
        Assertions.assertThrows(ProtocolException.class, () -> this.lambda$testSwitchInvalid$1((HttpResponse)response2));
        BasicHttpResponse response3 = new BasicHttpResponse(101);
        response3.addHeader("Upgrade", (Object)",,,");
        Assertions.assertThrows(ProtocolException.class, () -> this.lambda$testSwitchInvalid$2((HttpResponse)response3));
    }

    private /* synthetic */ void lambda$testSwitchInvalid$2(HttpResponse response3) throws Throwable {
        this.switchStrategy.switchProtocol((HttpMessage)response3);
    }

    private /* synthetic */ void lambda$testSwitchInvalid$1(HttpResponse response2) throws Throwable {
        this.switchStrategy.switchProtocol((HttpMessage)response2);
    }

    private /* synthetic */ void lambda$testSwitchInvalid$0(HttpResponse response1) throws Throwable {
        this.switchStrategy.switchProtocol((HttpMessage)response1);
    }
}

