/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.time.Instant;
import java.util.Map;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.impl.classic.ExponentialBackoffManager;
import org.apache.hc.client5.http.impl.classic.MockConnPoolControl;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.pool.ConnPoolControl;
import org.apache.hc.core5.util.TimeValue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TestExponentialBackoffManager {
    private ExponentialBackoffManager impl;
    private MockConnPoolControl connPerRoute;
    private HttpRoute route;
    private static final long DEFAULT_COOL_DOWN_MS = 5000L;

    TestExponentialBackoffManager() {
    }

    @BeforeEach
    void setUp() {
        this.connPerRoute = new MockConnPoolControl();
        this.route = new HttpRoute(new HttpHost("localhost", 80));
        this.impl = new ExponentialBackoffManager((ConnPoolControl)this.connPerRoute);
        this.impl.setPerHostConnectionCap(10);
        this.impl.setCoolDown(TimeValue.ofMilliseconds((long)5000L));
        this.impl.setBackoffFactor(1.75);
    }

    @Test
    void exponentialBackoffApplied() {
        this.connPerRoute.setMaxPerRoute(this.route, 4);
        this.impl.setBackoffFactor(2.0);
        this.impl.backOff(this.route);
        Assertions.assertEquals((int)1, (int)this.connPerRoute.getMaxPerRoute(this.route));
    }

    @Test
    void exponentialGrowthRateIsConfigurable() {
        int customCoolDownMs = 500;
        this.connPerRoute.setMaxPerRoute(this.route, 4);
        this.impl.setBackoffFactor(0.5);
        this.impl.setCoolDown(TimeValue.ofMilliseconds((long)500L));
        this.impl.backOff(this.route);
        Assertions.assertEquals((int)2, (int)this.connPerRoute.getMaxPerRoute(this.route));
        Map lastRouteBackoffs = this.impl.getLastRouteBackoffs();
        lastRouteBackoffs.put(this.route, Instant.now().minusMillis(501L));
        this.impl.backOff(this.route);
        Assertions.assertEquals((int)1, (int)this.connPerRoute.getMaxPerRoute(this.route));
    }

    @Test
    void doesNotIncreaseBeyondPerHostMaxOnProbe() {
        this.connPerRoute.setDefaultMaxPerRoute(5);
        this.connPerRoute.setMaxPerRoute(this.route, 5);
        this.impl.setPerHostConnectionCap(5);
        this.impl.probe(this.route);
        Assertions.assertEquals((int)5, (int)this.connPerRoute.getMaxPerRoute(this.route));
    }

    @Test
    void backoffDoesNotAdjustDuringCoolDownPeriod() {
        this.connPerRoute.setMaxPerRoute(this.route, 4);
        this.impl.backOff(this.route);
        long max = this.connPerRoute.getMaxPerRoute(this.route);
        Map lastRouteBackoffs = this.impl.getLastRouteBackoffs();
        lastRouteBackoffs.put(this.route, Instant.now().minusMillis(10L));
        this.impl.backOff(this.route);
        Assertions.assertEquals((long)max, (long)this.connPerRoute.getMaxPerRoute(this.route));
    }

    @Test
    void backoffStillAdjustsAfterCoolDownPeriod() {
        this.connPerRoute.setMaxPerRoute(this.route, 8);
        this.impl.backOff(this.route);
        long max = this.connPerRoute.getMaxPerRoute(this.route);
        Map lastRouteBackoffs = this.impl.getLastRouteBackoffs();
        lastRouteBackoffs.put(this.route, Instant.now().minusMillis(5001L));
        this.impl.backOff(this.route);
        Assertions.assertTrue((max == 1L || max > (long)this.connPerRoute.getMaxPerRoute(this.route) ? 1 : 0) != 0);
    }

    @Test
    void probeDoesNotAdjustDuringCooldownPeriod() {
        this.connPerRoute.setMaxPerRoute(this.route, 4);
        this.impl.probe(this.route);
        long max = this.connPerRoute.getMaxPerRoute(this.route);
        Map lastRouteProbes = this.impl.getLastRouteProbes();
        lastRouteProbes.put(this.route, Instant.now().minusMillis(0L));
        this.impl.probe(this.route);
        Assertions.assertEquals((long)max, (long)this.connPerRoute.getMaxPerRoute(this.route));
    }

    @Test
    void probeStillAdjustsAfterCoolDownPeriod() {
        this.connPerRoute.setMaxPerRoute(this.route, 8);
        this.impl.probe(this.route);
        long max = this.connPerRoute.getMaxPerRoute(this.route);
        Map lastRouteProbes = this.impl.getLastRouteProbes();
        lastRouteProbes.put(this.route, Instant.now().minusMillis(5001L));
        this.impl.probe(this.route);
        Assertions.assertTrue((max < (long)this.connPerRoute.getMaxPerRoute(this.route) ? 1 : 0) != 0);
    }

    @Test
    void willBackoffImmediatelyEvenAfterAProbe() {
        this.connPerRoute.setMaxPerRoute(this.route, 8);
        this.impl.probe(this.route);
        long max = this.connPerRoute.getMaxPerRoute(this.route);
        this.impl.backOff(this.route);
        Assertions.assertTrue(((long)this.connPerRoute.getMaxPerRoute(this.route) < max ? 1 : 0) != 0);
    }

    @Test
    void coolDownPeriodIsConfigurable() {
        long cd = 500L;
        this.impl.setCoolDown(TimeValue.ofMilliseconds((long)500L));
        this.connPerRoute.setMaxPerRoute(this.route, 4);
        this.impl.probe(this.route);
        int max0 = this.connPerRoute.getMaxPerRoute(this.route);
        Map lastRouteProbes = this.impl.getLastRouteProbes();
        lastRouteProbes.put(this.route, Instant.now().minusMillis(250L));
        this.impl.probe(this.route);
        Assertions.assertEquals((int)max0, (int)this.connPerRoute.getMaxPerRoute(this.route));
        lastRouteProbes.put(this.route, Instant.now().minusMillis(501L));
        this.impl.probe(this.route);
        Assertions.assertTrue((max0 < this.connPerRoute.getMaxPerRoute(this.route) ? 1 : 0) != 0);
    }
}

