/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.protocol;

import javax.net.ssl.SSLSession;
import org.apache.hc.client5.http.HeadersMatcher;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.protocol.RequestUpgrade;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class TestRequestUpgrade {
    private RequestUpgrade interceptor;
    private HttpClientContext context;

    TestRequestUpgrade() {
    }

    @BeforeEach
    void setUp() {
        this.interceptor = new RequestUpgrade();
        this.context = HttpClientContext.create();
    }

    @Test
    void testUpgrade() throws Exception {
        BasicHttpRequest get = new BasicHttpRequest("GET", "/");
        this.interceptor.process((HttpRequest)get, null, (HttpContext)this.context);
        MatcherAssert.assertThat((Object)get.getHeaders(), HeadersMatcher.same(new Header[]{new BasicHeader("Upgrade", (Object)"TLS/1.2"), new BasicHeader("Connection", (Object)"Upgrade")}));
        BasicHttpRequest options = new BasicHttpRequest("OPTIONS", "/");
        this.interceptor.process((HttpRequest)options, null, (HttpContext)this.context);
        MatcherAssert.assertThat((Object)options.getHeaders(), HeadersMatcher.same(new Header[]{new BasicHeader("Upgrade", (Object)"TLS/1.2"), new BasicHeader("Connection", (Object)"Upgrade")}));
        BasicHttpRequest head = new BasicHttpRequest("HEAD", "/");
        this.interceptor.process((HttpRequest)head, null, (HttpContext)this.context);
        MatcherAssert.assertThat((Object)head.getHeaders(), HeadersMatcher.same(new Header[]{new BasicHeader("Upgrade", (Object)"TLS/1.2"), new BasicHeader("Connection", (Object)"Upgrade")}));
    }

    @Test
    void testUpgradeDisabled() throws Exception {
        this.context.setRequestConfig(RequestConfig.custom().setProtocolUpgradeEnabled(false).build());
        BasicHttpRequest get = new BasicHttpRequest("GET", "/");
        this.interceptor.process((HttpRequest)get, null, (HttpContext)this.context);
        Assertions.assertFalse((boolean)get.containsHeader("Upgrade"));
    }

    @Test
    void testDoNotUpgradeHTTP2() throws Exception {
        this.context.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_2);
        BasicHttpRequest get = new BasicHttpRequest("GET", "/");
        this.interceptor.process((HttpRequest)get, null, (HttpContext)this.context);
        Assertions.assertFalse((boolean)get.containsHeader("Upgrade"));
    }

    @Test
    void testDoNotUpgradeHTTP10() throws Exception {
        this.context.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
        BasicHttpRequest get = new BasicHttpRequest("GET", "/");
        this.interceptor.process((HttpRequest)get, null, (HttpContext)this.context);
        Assertions.assertFalse((boolean)get.containsHeader("Upgrade"));
    }

    @Test
    void testDoUpgradeIfAlreadyTLS() throws Exception {
        this.context.setSSLSession((SSLSession)Mockito.mock(SSLSession.class));
        BasicHttpRequest get = new BasicHttpRequest("GET", "/");
        this.interceptor.process((HttpRequest)get, null, (HttpContext)this.context);
        Assertions.assertFalse((boolean)get.containsHeader("Upgrade"));
    }

    @Test
    void testDoUpgradeNonSafeMethodsOrTrace() throws Exception {
        BasicHttpRequest post = new BasicHttpRequest("POST", "/");
        this.interceptor.process((HttpRequest)post, null, (HttpContext)this.context);
        Assertions.assertFalse((boolean)post.containsHeader("Upgrade"));
        BasicHttpRequest put = new BasicHttpRequest("PUT", "/");
        this.interceptor.process((HttpRequest)put, null, (HttpContext)this.context);
        Assertions.assertFalse((boolean)put.containsHeader("Upgrade"));
        BasicHttpRequest patch = new BasicHttpRequest("PATCH", "/");
        this.interceptor.process((HttpRequest)patch, null, (HttpContext)this.context);
        Assertions.assertFalse((boolean)patch.containsHeader("Upgrade"));
        BasicHttpRequest trace = new BasicHttpRequest("TRACE", "/");
        this.interceptor.process((HttpRequest)trace, null, (HttpContext)this.context);
        Assertions.assertFalse((boolean)trace.containsHeader("Upgrade"));
    }
}

