/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.config;

import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestRequestConfig {
    TestRequestConfig() {
    }

    @Test
    void testBasics() {
        RequestConfig config = RequestConfig.custom().build();
        config.toString();
    }

    @Test
    void testDefaults() {
        RequestConfig config = RequestConfig.DEFAULT;
        Assertions.assertEquals((Object)Timeout.ofMinutes((long)3L), (Object)config.getConnectionRequestTimeout());
        Assertions.assertFalse((boolean)config.isExpectContinueEnabled());
        Assertions.assertTrue((boolean)config.isAuthenticationEnabled());
        Assertions.assertTrue((boolean)config.isRedirectsEnabled());
        Assertions.assertFalse((boolean)config.isCircularRedirectsAllowed());
        Assertions.assertEquals((int)50, (int)config.getMaxRedirects());
        Assertions.assertNull((Object)config.getCookieSpec());
        Assertions.assertNull((Object)config.getTargetPreferredAuthSchemes());
        Assertions.assertNull((Object)config.getProxyPreferredAuthSchemes());
        Assertions.assertTrue((boolean)config.isContentCompressionEnabled());
    }

    @Test
    void testBuildAndCopy() {
        RequestConfig config0 = RequestConfig.custom().setConnectionRequestTimeout(44L, TimeUnit.MILLISECONDS).setExpectContinueEnabled(true).setAuthenticationEnabled(false).setRedirectsEnabled(false).setCircularRedirectsAllowed(true).setMaxRedirects(100).setCookieSpec("strict").setTargetPreferredAuthSchemes(Collections.singletonList("Bearer")).setProxyPreferredAuthSchemes(Collections.singletonList("Digest")).setContentCompressionEnabled(false).build();
        RequestConfig config = RequestConfig.copy((RequestConfig)config0).build();
        Assertions.assertEquals((Object)TimeValue.ofMilliseconds((long)44L), (Object)config.getConnectionRequestTimeout());
        Assertions.assertTrue((boolean)config.isExpectContinueEnabled());
        Assertions.assertFalse((boolean)config.isAuthenticationEnabled());
        Assertions.assertFalse((boolean)config.isRedirectsEnabled());
        Assertions.assertTrue((boolean)config.isCircularRedirectsAllowed());
        Assertions.assertEquals((int)100, (int)config.getMaxRedirects());
        Assertions.assertEquals((Object)"strict", (Object)config.getCookieSpec());
        Assertions.assertEquals(Collections.singletonList("Bearer"), (Object)config.getTargetPreferredAuthSchemes());
        Assertions.assertEquals(Collections.singletonList("Digest"), (Object)config.getProxyPreferredAuthSchemes());
        Assertions.assertFalse((boolean)config.isContentCompressionEnabled());
    }
}

