/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.entity.mime;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.FormBodyPartBuilder;
import org.apache.hc.client5.http.entity.mime.HttpMultipartMode;
import org.apache.hc.client5.http.entity.mime.HttpStrictMultipart;
import org.apache.hc.client5.http.entity.mime.LegacyMultipart;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.entity.mime.MultipartFormEntity;
import org.apache.hc.client5.http.entity.mime.MultipartPart;
import org.apache.hc.client5.http.entity.mime.StringBody;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestMultipartEntityBuilder {
    TestMultipartEntityBuilder() {
    }

    @Test
    void testBasics() {
        MultipartFormEntity entity = MultipartEntityBuilder.create().buildEntity();
        Assertions.assertNotNull((Object)entity);
        Assertions.assertTrue((boolean)(entity.getMultipart() instanceof HttpStrictMultipart));
        Assertions.assertEquals((int)0, (int)entity.getMultipart().getParts().size());
    }

    @Test
    void testMultipartOptions() {
        MultipartFormEntity entity = MultipartEntityBuilder.create().setBoundary("blah-blah").setCharset(StandardCharsets.UTF_8).setLaxMode().buildEntity();
        Assertions.assertNotNull((Object)entity);
        Assertions.assertTrue((boolean)(entity.getMultipart() instanceof LegacyMultipart));
        Assertions.assertEquals((Object)"blah-blah", (Object)entity.getMultipart().boundary);
        Assertions.assertEquals((Object)StandardCharsets.UTF_8, (Object)entity.getMultipart().charset);
    }

    @Test
    void testAddBodyParts() {
        MultipartFormEntity entity = MultipartEntityBuilder.create().addTextBody("p1", "stuff").addBinaryBody("p2", new File("stuff")).addBinaryBody("p3", new byte[0]).addBinaryBody("p4", (InputStream)new ByteArrayInputStream(new byte[0])).addBinaryBody("p5", (InputStream)new ByteArrayInputStream(new byte[0]), ContentType.DEFAULT_BINARY, "filename").buildEntity();
        Assertions.assertNotNull((Object)entity);
        List bodyParts = entity.getMultipart().getParts();
        Assertions.assertNotNull((Object)bodyParts);
        Assertions.assertEquals((int)5, (int)bodyParts.size());
    }

    @Test
    void testMultipartCustomContentType() {
        MultipartFormEntity entity = MultipartEntityBuilder.create().setContentType(ContentType.APPLICATION_XML).setBoundary("blah-blah").setCharset(StandardCharsets.UTF_8).setLaxMode().buildEntity();
        Assertions.assertNotNull((Object)entity);
        Assertions.assertEquals((Object)"application/xml; charset=UTF-8; boundary=blah-blah", (Object)entity.getContentType());
    }

    @Test
    void testMultipartContentTypeParameter() {
        MultipartFormEntity entity = MultipartEntityBuilder.create().setContentType(ContentType.MULTIPART_FORM_DATA.withParameters(new NameValuePair[]{new BasicNameValuePair("boundary", "yada-yada"), new BasicNameValuePair("charset", "ascii")})).buildEntity();
        Assertions.assertNotNull((Object)entity);
        Assertions.assertEquals((Object)"multipart/form-data; boundary=yada-yada; charset=ascii", (Object)entity.getContentType());
        Assertions.assertEquals((Object)"yada-yada", (Object)entity.getMultipart().boundary);
        Assertions.assertEquals((Object)StandardCharsets.US_ASCII, (Object)entity.getMultipart().charset);
    }

    @Test
    void testMultipartDefaultContentTypeOmitsCharset() {
        MultipartFormEntity entity = MultipartEntityBuilder.create().setCharset(StandardCharsets.UTF_8).setBoundary("yada-yada").buildEntity();
        Assertions.assertNotNull((Object)entity);
        Assertions.assertEquals((Object)"multipart/mixed; boundary=yada-yada", (Object)entity.getContentType());
        Assertions.assertEquals((Object)"yada-yada", (Object)entity.getMultipart().boundary);
    }

    @Test
    void testMultipartFormDataContentTypeOmitsCharset() {
        MultipartFormEntity entity = MultipartEntityBuilder.create().setContentType(ContentType.create((String)"multipart/form-data")).setCharset(StandardCharsets.UTF_8).setBoundary("yada-yada").buildEntity();
        Assertions.assertNotNull((Object)entity);
        Assertions.assertEquals((Object)"multipart/form-data; boundary=yada-yada", (Object)entity.getContentType());
        Assertions.assertEquals((Object)"yada-yada", (Object)entity.getMultipart().boundary);
    }

    @Test
    void testMultipartCustomContentTypeParameterOverrides() {
        MultipartFormEntity entity = MultipartEntityBuilder.create().setContentType(ContentType.MULTIPART_FORM_DATA.withParameters(new NameValuePair[]{new BasicNameValuePair("boundary", "yada-yada"), new BasicNameValuePair("charset", "ascii"), new BasicNameValuePair("my", "stuff")})).setBoundary("blah-blah").setCharset(StandardCharsets.UTF_8).setLaxMode().buildEntity();
        Assertions.assertNotNull((Object)entity);
        Assertions.assertEquals((Object)"multipart/form-data; boundary=blah-blah; charset=ascii; my=stuff", (Object)entity.getContentType());
    }

    @Test
    void testMultipartCustomContentTypeUsingAddParameter() {
        MultipartEntityBuilder eb = MultipartEntityBuilder.create();
        eb.setMimeSubtype("related");
        eb.addParameter(new BasicNameValuePair("boundary", "yada-yada"));
        eb.addParameter(new BasicNameValuePair("charset", "ascii"));
        eb.addParameter(new BasicNameValuePair("my", "stuff"));
        eb.buildEntity();
        MultipartFormEntity entity = eb.buildEntity();
        Assertions.assertNotNull((Object)entity);
        Assertions.assertEquals((Object)"multipart/related; boundary=yada-yada; charset=ascii; my=stuff", (Object)entity.getContentType());
    }

    @Test
    void testMultipartWriteTo() throws Exception {
        String helloWorld = "hello world";
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("name", "test"));
        parameters.add(new BasicNameValuePair("filename", "hello world"));
        MultipartFormEntity entity = MultipartEntityBuilder.create().setStrictMode().setBoundary("xxxxxxxxxxxxxxxxxxxxxxxx").addPart((MultipartPart)new FormBodyPartBuilder().setName("test").setBody((ContentBody)new StringBody("hello world", ContentType.TEXT_PLAIN)).addField("Content-Disposition", "multipart/form-data", parameters).build()).buildEntity();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        entity.writeTo((OutputStream)out);
        out.close();
        Assertions.assertEquals((Object)"--xxxxxxxxxxxxxxxxxxxxxxxx\r\nContent-Disposition: multipart/form-data; name=\"test\"; filename=\"hello world\"\r\nContent-Type: text/plain; charset=UTF-8\r\n\r\nhello world\r\n--xxxxxxxxxxxxxxxxxxxxxxxx--\r\n", (Object)out.toString(StandardCharsets.US_ASCII.name()));
    }

    @Test
    void testMultipartWriteToRFC7578Mode() throws Exception {
        String helloWorld = "hello \u03ba\u03cc\u03c3\u03bc\u03b5!%";
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("name", "test"));
        parameters.add(new BasicNameValuePair("filename", "hello \u03ba\u03cc\u03c3\u03bc\u03b5!%"));
        MultipartFormEntity entity = MultipartEntityBuilder.create().setMode(HttpMultipartMode.EXTENDED).setBoundary("xxxxxxxxxxxxxxxxxxxxxxxx").addPart((MultipartPart)new FormBodyPartBuilder().setName("test").setBody((ContentBody)new StringBody("hello \u03ba\u03cc\u03c3\u03bc\u03b5!%", ContentType.TEXT_PLAIN.withCharset(StandardCharsets.UTF_8))).addField("Content-Disposition", "multipart/form-data", parameters).build()).buildEntity();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        entity.writeTo((OutputStream)out);
        out.close();
        Assertions.assertEquals((Object)"--xxxxxxxxxxxxxxxxxxxxxxxx\r\nContent-Disposition: multipart/form-data; name=\"test\"; filename=\"hello%20%CE%BA%CF%8C%CF%83%CE%BC%CE%B5!%25\"\r\nContent-Type: text/plain; charset=UTF-8\r\n\r\nhello \u00ce\u00ba\u00cf\u008c\u00cf\u0083\u00ce\u00bc\u00ce\u00b5!%\r\n--xxxxxxxxxxxxxxxxxxxxxxxx--\r\n", (Object)out.toString(StandardCharsets.ISO_8859_1.name()));
    }

    @Test
    void testMultipartWriteToRFC6532Mode() throws Exception {
        String helloWorld = "hello \u03ba\u03cc\u03c3\u03bc\u03b5!%";
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("name", "test"));
        parameters.add(new BasicNameValuePair("filename", "hello \u03ba\u03cc\u03c3\u03bc\u03b5!%"));
        MultipartFormEntity entity = MultipartEntityBuilder.create().setMode(HttpMultipartMode.EXTENDED).setContentType(ContentType.create((String)"multipart/other")).setBoundary("xxxxxxxxxxxxxxxxxxxxxxxx").addPart((MultipartPart)new FormBodyPartBuilder().setName("test").setBody((ContentBody)new StringBody("hello \u03ba\u03cc\u03c3\u03bc\u03b5!%", ContentType.TEXT_PLAIN.withCharset(StandardCharsets.UTF_8))).addField("Content-Disposition", "multipart/form-data", parameters).build()).buildEntity();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        entity.writeTo((OutputStream)out);
        out.close();
        Assertions.assertEquals((Object)"--xxxxxxxxxxxxxxxxxxxxxxxx\r\nContent-Disposition: multipart/form-data; name=\"test\"; filename=\"hello \u00ce\u00ba\u00cf\u008c\u00cf\u0083\u00ce\u00bc\u00ce\u00b5!%\"\r\nContent-Type: text/plain; charset=UTF-8\r\n\r\nhello \u00ce\u00ba\u00cf\u008c\u00cf\u0083\u00ce\u00bc\u00ce\u00b5!%\r\n--xxxxxxxxxxxxxxxxxxxxxxxx--\r\n", (Object)out.toString(StandardCharsets.ISO_8859_1.name()));
    }

    @Test
    void testMultipartWriteToWithPreambleAndEpilogue() throws Exception {
        String helloWorld = "hello \u03ba\u03cc\u03c3\u03bc\u03b5!%";
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("name", "test"));
        parameters.add(new BasicNameValuePair("filename", "hello \u03ba\u03cc\u03c3\u03bc\u03b5!%"));
        MultipartFormEntity entity = MultipartEntityBuilder.create().setMode(HttpMultipartMode.EXTENDED).setContentType(ContentType.create((String)"multipart/other")).setBoundary("xxxxxxxxxxxxxxxxxxxxxxxx").addPart((MultipartPart)new FormBodyPartBuilder().setName("test").setBody((ContentBody)new StringBody("hello \u03ba\u03cc\u03c3\u03bc\u03b5!%", ContentType.TEXT_PLAIN.withCharset(StandardCharsets.UTF_8))).addField("Content-Disposition", "multipart/form-data", parameters).build()).addPreamble("This is the preamble.").addEpilogue("This is the epilogue.").buildEntity();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        entity.writeTo((OutputStream)out);
        out.close();
        Assertions.assertEquals((Object)"This is the preamble.\r\n--xxxxxxxxxxxxxxxxxxxxxxxx\r\nContent-Disposition: multipart/form-data; name=\"test\"; filename=\"hello \u00ce\u00ba\u00cf\u008c\u00cf\u0083\u00ce\u00bc\u00ce\u00b5!%\"\r\nContent-Type: text/plain; charset=UTF-8\r\n\r\nhello \u00ce\u00ba\u00cf\u008c\u00cf\u0083\u00ce\u00bc\u00ce\u00b5!%\r\n--xxxxxxxxxxxxxxxxxxxxxxxx--\r\nThis is the epilogue.\r\n", (Object)out.toString(StandardCharsets.ISO_8859_1.name()));
    }

    @Test
    void testMultipartWriteToRFC7578ModeWithFilenameStar() throws Exception {
        String helloWorld = "hello \u03ba\u03cc\u03c3\u03bc\u03b5!%";
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("name", "test"));
        parameters.add(new BasicNameValuePair("filename*", "hello \u03ba\u03cc\u03c3\u03bc\u03b5!%"));
        MultipartFormEntity entity = MultipartEntityBuilder.create().setMode(HttpMultipartMode.EXTENDED).setBoundary("xxxxxxxxxxxxxxxxxxxxxxxx").addPart((MultipartPart)new FormBodyPartBuilder().setName("test").setBody((ContentBody)new StringBody("hello \u03ba\u03cc\u03c3\u03bc\u03b5!%", ContentType.TEXT_PLAIN.withCharset(StandardCharsets.UTF_8))).addField("Content-Disposition", "multipart/form-data", parameters).build()).buildEntity();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        entity.writeTo((OutputStream)out);
        out.close();
        Assertions.assertEquals((Object)"--xxxxxxxxxxxxxxxxxxxxxxxx\r\nContent-Disposition: multipart/form-data; name=\"test\"; filename*=\"UTF-8''hello%20%CE%BA%CF%8C%CF%83%CE%BC%CE%B5!%25\"\r\nContent-Type: text/plain; charset=UTF-8\r\n\r\nhello \u00ce\u00ba\u00cf\u008c\u00cf\u0083\u00ce\u00bc\u00ce\u00b5!%\r\n--xxxxxxxxxxxxxxxxxxxxxxxx--\r\n", (Object)out.toString(StandardCharsets.ISO_8859_1.name()));
    }
}

