/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.examples;

import java.util.concurrent.Future;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.async.methods.SimpleRequestBuilder;
import org.apache.hc.client5.http.async.methods.SimpleRequestProducer;
import org.apache.hc.client5.http.async.methods.SimpleResponseConsumer;
import org.apache.hc.client5.http.impl.ChainElement;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.entity.DigestingEntityProducer;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.util.Timeout;

public class AsyncClientMessageTrailers {
    public static final void main(String[] args) throws Exception {
        IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setSoTimeout(Timeout.ofSeconds((long)5L)).build();
        CloseableHttpAsyncClient client = HttpAsyncClients.custom().setIOReactorConfig(ioReactorConfig).addExecInterceptorAfter(ChainElement.PROTOCOL.name(), "custom", (request, entityProducer, scope, chain, asyncExecCallback) -> chain.proceed(request, (AsyncEntityProducer)(entityProducer != null ? new DigestingEntityProducer("MD5", entityProducer) : null), scope, asyncExecCallback)).build();
        client.start();
        final SimpleHttpRequest request2 = SimpleRequestBuilder.post((String)"http://httpbin.org/post").setBody("some stuff", ContentType.TEXT_PLAIN).build();
        System.out.println("Executing request " + request2);
        Future future = client.execute((AsyncRequestProducer)SimpleRequestProducer.create((SimpleHttpRequest)request2), (AsyncResponseConsumer)SimpleResponseConsumer.create(), (FutureCallback)new FutureCallback<SimpleHttpResponse>(){

            public void completed(SimpleHttpResponse response) {
                System.out.println(request2 + "->" + new StatusLine((HttpResponse)response));
                System.out.println(response.getBody());
            }

            public void failed(Exception ex) {
                System.out.println(request2 + "->" + ex);
            }

            public void cancelled() {
                System.out.println(request2 + " cancelled");
            }
        });
        future.get();
        System.out.println("Shutting down");
        client.close(CloseMode.GRACEFUL);
    }
}

