/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.examples;

import java.util.concurrent.Future;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.async.methods.SimpleRequestBuilder;
import org.apache.hc.client5.http.async.methods.SimpleRequestProducer;
import org.apache.hc.client5.http.async.methods.SimpleResponseConsumer;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.CloseMode;

public class AsyncClientSNI {
    public static void main(String[] args) throws Exception {
        try (CloseableHttpAsyncClient client = HttpAsyncClients.createSystem();){
            client.start();
            HttpHost target = new HttpHost("https", "www.google.com");
            final SimpleHttpRequest request = SimpleRequestBuilder.get().setUri("https://www.google.ch/").build();
            final HttpClientContext clientContext = HttpClientContext.create();
            System.out.println("Executing request " + request);
            Future future = client.execute(target, (AsyncRequestProducer)SimpleRequestProducer.create((SimpleHttpRequest)request), (AsyncResponseConsumer)SimpleResponseConsumer.create(), null, (HttpContext)clientContext, (FutureCallback)new FutureCallback<SimpleHttpResponse>(){

                public void completed(SimpleHttpResponse response) {
                    System.out.println(request + "->" + new StatusLine((HttpResponse)response));
                    SSLSession sslSession = clientContext.getSSLSession();
                    if (sslSession != null) {
                        try {
                            System.out.println("Peer: " + sslSession.getPeerPrincipal());
                            System.out.println("TLS protocol: " + sslSession.getProtocol());
                            System.out.println("TLS cipher suite: " + sslSession.getCipherSuite());
                        }
                        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                            // empty catch block
                        }
                    }
                }

                public void failed(Exception ex) {
                    System.out.println(request + "->" + ex);
                }

                public void cancelled() {
                    System.out.println(request + " cancelled");
                }
            });
            future.get();
            System.out.println("Shutting down");
            client.close(CloseMode.GRACEFUL);
        }
    }
}

