/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.examples;

import java.net.URI;
import java.util.List;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.cookie.BasicCookieStore;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;

public class ClientFormLogin {
    public static void main(String[] args) throws Exception {
        BasicCookieStore cookieStore = new BasicCookieStore();
        try (CloseableHttpClient httpclient = HttpClients.custom().setDefaultCookieStore((CookieStore)cookieStore).build();){
            HttpGet httpget = new HttpGet("https://someportal/");
            httpclient.execute((ClassicHttpRequest)httpget, response -> {
                System.out.println("----------------------------------------");
                System.out.println("Login form get: " + response.getCode() + " " + response.getReasonPhrase());
                EntityUtils.consume((HttpEntity)response.getEntity());
                System.out.println("Initial set of cookies:");
                List cookies = cookieStore.getCookies();
                if (cookies.isEmpty()) {
                    System.out.println("None");
                } else {
                    for (int i = 0; i < cookies.size(); ++i) {
                        System.out.println("- " + cookies.get(i));
                    }
                }
                return null;
            });
            ClassicHttpRequest login = ClassicRequestBuilder.post().setUri(new URI("https://someportal/")).addParameter("IDToken1", "username").addParameter("IDToken2", "password").build();
            httpclient.execute(login, response -> {
                System.out.println("----------------------------------------");
                System.out.println("Login form get: " + response.getCode() + " " + response.getReasonPhrase());
                EntityUtils.consume((HttpEntity)response.getEntity());
                System.out.println("Post logon cookies:");
                List cookies = cookieStore.getCookies();
                if (cookies.isEmpty()) {
                    System.out.println("None");
                } else {
                    for (int i = 0; i < cookies.size(); ++i) {
                        System.out.println("- " + cookies.get(i));
                    }
                }
                return null;
            });
        }
    }
}

