/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.examples;

import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.auth.CredentialsProviderBuilder;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.StatusLine;

public class ClientProxyAuthentication {
    public static void main(String[] args) throws Exception {
        CredentialsProvider credsProvider = CredentialsProviderBuilder.create().add(new AuthScope("localhost", 8888), "squid", "squid".toCharArray()).add(new AuthScope("httpbin.org", 80), "user", "passwd".toCharArray()).build();
        HttpHost target = new HttpHost("http", "httpbin.org", 80);
        HttpHost proxy = new HttpHost("localhost", 8888);
        try (CloseableHttpClient httpclient = HttpClients.custom().setProxy(proxy).setDefaultCredentialsProvider(credsProvider).build();){
            RequestConfig config = RequestConfig.custom().build();
            HttpGet httpget = new HttpGet("/basic-auth/user/passwd");
            httpget.setConfig(config);
            System.out.println("Executing request " + httpget.getMethod() + " " + httpget.getUri() + " to " + target + " via " + proxy);
            httpclient.execute(target, (ClassicHttpRequest)httpget, response -> {
                System.out.println("----------------------------------------");
                System.out.println(httpget + "->" + new StatusLine((HttpResponse)response));
                EntityUtils.consume((HttpEntity)response.getEntity());
                return null;
            });
        }
    }
}

