/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.examples;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.FutureRequestExecutionService;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.protocol.HttpContext;

public class ClientWithRequestFuture {
    public static void main(String[] args) throws Exception {
        PoolingHttpClientConnectionManager cm = PoolingHttpClientConnectionManagerBuilder.create().setMaxConnPerRoute(5).setMaxConnTotal(5).build();
        CloseableHttpClient httpclient = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)cm).build();
        ExecutorService execService = Executors.newFixedThreadPool(5);
        try (FutureRequestExecutionService requestExecService = new FutureRequestExecutionService((HttpClient)httpclient, execService);){
            HttpClientResponseHandler handler = response -> response.getCode() == 200;
            HttpGet request1 = new HttpGet("http://httpbin.org/get");
            FutureTask futureTask1 = requestExecService.execute((ClassicHttpRequest)request1, (HttpContext)HttpClientContext.create(), handler);
            Boolean wasItOk1 = (Boolean)futureTask1.get();
            System.out.println("It was ok? " + wasItOk1);
            try {
                HttpGet request2 = new HttpGet("http://httpbin.org/get");
                FutureTask futureTask2 = requestExecService.execute((ClassicHttpRequest)request2, (HttpContext)HttpClientContext.create(), handler);
                futureTask2.cancel(true);
                Boolean wasItOk2 = (Boolean)futureTask2.get();
                System.out.println("It was cancelled so it should never print this: " + wasItOk2);
            }
            catch (CancellationException e) {
                System.out.println("We cancelled it, so this is expected");
            }
            HttpGet request3 = new HttpGet("http://httpbin.org/get");
            FutureTask futureTask3 = requestExecService.execute((ClassicHttpRequest)request3, (HttpContext)HttpClientContext.create(), handler);
            Boolean wasItOk3 = (Boolean)futureTask3.get(10L, TimeUnit.SECONDS);
            System.out.println("It was ok? " + wasItOk3);
            FutureCallback<Boolean> callback = new FutureCallback<Boolean>(){

                public void completed(Boolean result) {
                    System.out.println("completed with " + result);
                }

                public void failed(Exception ex) {
                    System.out.println("failed with " + ex.getMessage());
                }

                public void cancelled() {
                    System.out.println("cancelled");
                }
            };
            HttpGet request4 = new HttpGet("http://httpbin.org/get");
            FutureTask futureTask4 = requestExecService.execute((ClassicHttpRequest)request4, (HttpContext)HttpClientContext.create(), handler, (FutureCallback)callback);
            Boolean wasItOk4 = (Boolean)futureTask4.get(10L, TimeUnit.SECONDS);
            System.out.println("It was ok? " + wasItOk4);
        }
    }
}

