/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hc.client5.http.impl.classic.RequestEntityProxy;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class RequestEntityProxyTest {
    RequestEntityProxyTest() {
    }

    @Test
    void testEnhanceWrapsNonRepeatableEntity() {
        HttpEntity entity = (HttpEntity)Mockito.mock(HttpEntity.class);
        Mockito.when((Object)entity.isRepeatable()).thenReturn((Object)false);
        ClassicHttpRequest request = (ClassicHttpRequest)Mockito.mock(ClassicHttpRequest.class);
        Mockito.when((Object)request.getEntity()).thenReturn((Object)entity);
        RequestEntityProxy.enhance((ClassicHttpRequest)request);
        ArgumentCaptor captor = ArgumentCaptor.forClass(HttpEntity.class);
        ((ClassicHttpRequest)Mockito.verify((Object)request)).setEntity((HttpEntity)captor.capture());
        HttpEntity proxy = (HttpEntity)captor.getValue();
        Assertions.assertInstanceOf(RequestEntityProxy.class, (Object)proxy, (String)"Entity should be wrapped as RequestEntityProxy");
        Assertions.assertSame((Object)entity, (Object)((RequestEntityProxy)proxy).getOriginal(), (String)"The proxy should wrap the original entity");
    }

    @Test
    void testEnhanceDoesNotWrapRepeatableEntity() {
        HttpEntity entity = (HttpEntity)Mockito.mock(HttpEntity.class);
        Mockito.when((Object)entity.isRepeatable()).thenReturn((Object)true);
        ClassicHttpRequest request = (ClassicHttpRequest)Mockito.mock(ClassicHttpRequest.class);
        Mockito.when((Object)request.getEntity()).thenReturn((Object)entity);
        RequestEntityProxy.enhance((ClassicHttpRequest)request);
        ((ClassicHttpRequest)Mockito.verify((Object)request, (VerificationMode)Mockito.never())).setEntity((HttpEntity)ArgumentMatchers.any(HttpEntity.class));
    }

    @Test
    void testIsRepeatableBehavior() throws IOException {
        HttpEntity entity = (HttpEntity)Mockito.mock(HttpEntity.class);
        Mockito.when((Object)entity.isRepeatable()).thenReturn((Object)false);
        RequestEntityProxy proxy = new RequestEntityProxy(entity);
        Assertions.assertTrue((boolean)proxy.isRepeatable(), (String)"Proxy should be repeatable before consumption");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        proxy.writeTo((OutputStream)out);
        Assertions.assertFalse((boolean)proxy.isRepeatable(), (String)"Proxy should not be repeatable after consumption");
    }
}

