/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.io.IOException;
import java.net.Socket;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.ProxyClient;
import org.apache.hc.client5.http.io.ManagedHttpClientConnection;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.impl.io.HttpRequestExecutor;
import org.apache.hc.core5.http.io.HttpClientConnection;
import org.apache.hc.core5.http.io.HttpConnectionFactory;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class TestProxyClient {
    TestProxyClient() {
    }

    @Test
    void testTunnelWithInvalidPort() throws IOException {
        HttpConnectionFactory connFactory = (HttpConnectionFactory)Mockito.mock(HttpConnectionFactory.class);
        ManagedHttpClientConnection managedConnection = (ManagedHttpClientConnection)Mockito.mock(ManagedHttpClientConnection.class);
        Mockito.when((Object)connFactory.createConnection(null)).thenReturn((Object)managedConnection);
        HttpRequestExecutor requestExecutor = (HttpRequestExecutor)Mockito.mock(HttpRequestExecutor.class);
        ClassicHttpResponse response = (ClassicHttpResponse)Mockito.mock(ClassicHttpResponse.class);
        Mockito.when((Object)response.getCode()).thenReturn((Object)200);
        try {
            Mockito.when((Object)requestExecutor.execute((ClassicHttpRequest)ArgumentMatchers.any(), (HttpClientConnection)ArgumentMatchers.any(), (HttpContext)ArgumentMatchers.any())).thenReturn((Object)response);
        }
        catch (IOException | HttpException e) {
            Assertions.fail((String)"Shouldn't fail");
        }
        RequestConfig requestConfig = RequestConfig.DEFAULT;
        ProxyClient client = new ProxyClient(connFactory, null, null, requestConfig);
        HttpHost proxy = new HttpHost("proxy.example.com", 8080);
        HttpHost target = new HttpHost("target.example.com", -1);
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("user", "pass".toCharArray());
        Assertions.assertThrows(IllegalArgumentException.class, () -> TestProxyClient.lambda$testTunnelWithInvalidPort$0(client, proxy, target, (Credentials)credentials));
    }

    @Test
    void testSuccessfulTunnel() throws IOException, HttpException {
        HttpConnectionFactory connFactory = (HttpConnectionFactory)Mockito.mock(HttpConnectionFactory.class);
        ManagedHttpClientConnection managedConnection = (ManagedHttpClientConnection)Mockito.mock(ManagedHttpClientConnection.class);
        Mockito.when((Object)managedConnection.isOpen()).thenReturn((Object)true);
        Mockito.when((Object)connFactory.createConnection(null)).thenReturn((Object)managedConnection);
        ClassicHttpResponse mockResponse = (ClassicHttpResponse)Mockito.mock(ClassicHttpResponse.class);
        Mockito.when((Object)mockResponse.getCode()).thenReturn((Object)200);
        Mockito.when((Object)managedConnection.receiveResponseHeader()).thenReturn((Object)mockResponse);
        HttpRequestExecutor mockRequestExecutor = (HttpRequestExecutor)Mockito.mock(HttpRequestExecutor.class);
        Mockito.when((Object)mockRequestExecutor.execute((ClassicHttpRequest)ArgumentMatchers.any(), (HttpClientConnection)ArgumentMatchers.any(), (HttpContext)ArgumentMatchers.any())).thenReturn((Object)mockResponse);
        Socket mockSocket = (Socket)Mockito.mock(Socket.class);
        Mockito.when((Object)managedConnection.getSocket()).thenReturn((Object)mockSocket);
        RequestConfig requestConfig = RequestConfig.DEFAULT;
        ProxyClient client = new ProxyClient(connFactory, null, null, requestConfig);
        HttpHost proxy = new HttpHost("proxy.example.com", 8080);
        HttpHost target = new HttpHost("target.example.com", 80);
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("user", "pass".toCharArray());
        Socket resultSocket = client.tunnel(proxy, target, (Credentials)credentials);
        Assertions.assertNotNull((Object)resultSocket, (String)"Expected a valid socket object");
        Assertions.assertEquals((Object)mockSocket, (Object)resultSocket, (String)"Expected the mock socket to be returned");
    }

    private static /* synthetic */ void lambda$testTunnelWithInvalidPort$0(ProxyClient client, HttpHost proxy, HttpHost target, Credentials credentials) throws Throwable {
        client.tunnel(proxy, target, credentials);
    }
}

