/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cookie;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.hc.client5.http.impl.cookie.BasicClientCookie;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestBasicClientCookie {
    TestBasicClientCookie() {
    }

    @Test
    void testConstructor() {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        Assertions.assertEquals((Object)"name", (Object)cookie.getName());
        Assertions.assertEquals((Object)"value", (Object)cookie.getValue());
        Assertions.assertThrows(NullPointerException.class, () -> new BasicClientCookie(null, null));
    }

    @Test
    void testCloning() throws Exception {
        BasicClientCookie orig = new BasicClientCookie("name", "value");
        orig.setDomain("domain");
        orig.setPath("/");
        orig.setAttribute("attrib", "stuff");
        BasicClientCookie clone = (BasicClientCookie)orig.clone();
        Assertions.assertEquals((Object)orig.getName(), (Object)clone.getName());
        Assertions.assertEquals((Object)orig.getValue(), (Object)clone.getValue());
        Assertions.assertEquals((Object)orig.getDomain(), (Object)clone.getDomain());
        Assertions.assertEquals((Object)orig.getPath(), (Object)clone.getPath());
        Assertions.assertEquals((Object)orig.getAttribute("attrib"), (Object)clone.getAttribute("attrib"));
    }

    @Test
    void testSerialization() throws Exception {
        BasicClientCookie orig = new BasicClientCookie("name", "value");
        orig.setDomain("domain");
        orig.setPath("/");
        orig.setAttribute("attrib", "stuff");
        ByteArrayOutputStream outbuffer = new ByteArrayOutputStream();
        ObjectOutputStream outStream = new ObjectOutputStream(outbuffer);
        outStream.writeObject(orig);
        outStream.close();
        byte[] raw = outbuffer.toByteArray();
        ByteArrayInputStream inBuffer = new ByteArrayInputStream(raw);
        ObjectInputStream inStream = new ObjectInputStream(inBuffer);
        BasicClientCookie clone = (BasicClientCookie)inStream.readObject();
        Assertions.assertEquals((Object)orig.getName(), (Object)clone.getName());
        Assertions.assertEquals((Object)orig.getValue(), (Object)clone.getValue());
        Assertions.assertEquals((Object)orig.getDomain(), (Object)clone.getDomain());
        Assertions.assertEquals((Object)orig.getPath(), (Object)clone.getPath());
        Assertions.assertEquals((Object)orig.getAttribute("attrib"), (Object)clone.getAttribute("attrib"));
    }
}

