/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cookie;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import org.apache.hc.client5.http.cookie.BasicCookieStore;
import org.apache.hc.client5.http.cookie.Cookie;
import org.apache.hc.client5.http.impl.cookie.BasicClientCookie;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestBasicCookieStore {
    TestBasicCookieStore() {
    }

    @Test
    void testBasics() {
        BasicCookieStore store = new BasicCookieStore();
        store.addCookie((Cookie)new BasicClientCookie("name1", "value1"));
        store.addCookies((Cookie[])new BasicClientCookie[]{new BasicClientCookie("name2", "value2")});
        List list = store.getCookies();
        Assertions.assertNotNull((Object)list);
        Assertions.assertEquals((int)2, (int)list.size());
        Assertions.assertEquals((Object)"name1", (Object)((Cookie)list.get(0)).getName());
        Assertions.assertEquals((Object)"name2", (Object)((Cookie)list.get(1)).getName());
        store.clear();
        list = store.getCookies();
        Assertions.assertNotNull((Object)list);
        Assertions.assertEquals((int)0, (int)list.size());
    }

    @Test
    void testExpiredCookie() {
        BasicCookieStore store = new BasicCookieStore();
        BasicClientCookie cookie = new BasicClientCookie("name1", "value1");
        Instant minus_10_days = Instant.now().minus(10L, ChronoUnit.DAYS);
        cookie.setExpiryDate(minus_10_days);
        store.addCookie((Cookie)cookie);
        List list = store.getCookies();
        Assertions.assertNotNull((Object)list);
        Assertions.assertEquals((int)0, (int)list.size());
    }

    @Test
    void testSerialization() throws Exception {
        BasicCookieStore orig = new BasicCookieStore();
        orig.addCookie((Cookie)new BasicClientCookie("name1", "value1"));
        orig.addCookie((Cookie)new BasicClientCookie("name2", "value2"));
        ByteArrayOutputStream outbuffer = new ByteArrayOutputStream();
        ObjectOutputStream outStream = new ObjectOutputStream(outbuffer);
        outStream.writeObject(orig);
        outStream.close();
        byte[] raw = outbuffer.toByteArray();
        ByteArrayInputStream inBuffer = new ByteArrayInputStream(raw);
        ObjectInputStream inStream = new ObjectInputStream(inBuffer);
        BasicCookieStore clone = (BasicCookieStore)inStream.readObject();
        List expected = orig.getCookies();
        List clones = clone.getCookies();
        Assertions.assertNotNull((Object)expected);
        Assertions.assertNotNull((Object)clones);
        Assertions.assertEquals((int)expected.size(), (int)clones.size());
        for (int i = 0; i < expected.size(); ++i) {
            Assertions.assertEquals((Object)((Cookie)expected.get(i)).getName(), (Object)((Cookie)clones.get(i)).getName());
            Assertions.assertEquals((Object)((Cookie)expected.get(i)).getValue(), (Object)((Cookie)clones.get(i)).getValue());
        }
    }
}

