/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.stylecheck;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

@StatelessCheck
public final class TestCaseMethodVisibilityCheck
extends AbstractCheck {
    private static final Set<String> TARGET_ANNOTATIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("BeforeAll", "BeforeEach", "Test", "AfterEach", "AfterAll")));
    public static final String MSG_KEY = "testcase.method.visibility";

    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    public int[] getAcceptableTokens() {
        return new int[]{9};
    }

    public void visitToken(DetailAST ast) {
        if (ast.getType() == 9 && TestCaseMethodVisibilityCheck.isAnnotatedAsTest(ast)) {
            DetailAST privateModifier;
            DetailAST modifiers = ast.findFirstToken(5);
            DetailAST publicModifier = modifiers.findFirstToken(62);
            if (publicModifier != null) {
                this.log(publicModifier, MSG_KEY, new Object[]{"public"});
            }
            if ((privateModifier = modifiers.findFirstToken(61)) != null) {
                this.log(modifiers, MSG_KEY, new Object[]{"private"});
            }
        }
    }

    private static boolean isAnnotatedAsTest(DetailAST methodDef) {
        DetailAST modifiers = methodDef.findFirstToken(5);
        Optional annotation = TokenUtil.findFirstTokenByPredicate((DetailAST)modifiers, currentToken -> currentToken.getType() == 159 && TARGET_ANNOTATIONS.contains(TestCaseMethodVisibilityCheck.getAnnotationName(currentToken)));
        return annotation.isPresent();
    }

    private static String getAnnotationName(DetailAST annotation) {
        DetailAST dotAst = annotation.findFirstToken(59);
        if (dotAst == null) {
            return annotation.findFirstToken(58).getText();
        }
        return dotAst.findFirstToken(58).getText();
    }
}

